/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin;

import com.atlassian.confluence.plugin.ConfluenceWebTester;
import com.atlassian.confluence.plugin.helper.AttachmentHelper;
import com.atlassian.confluence.plugin.helper.BandanaHelper;
import com.atlassian.confluence.plugin.helper.BlogPostHelper;
import com.atlassian.confluence.plugin.helper.CommentHelper;
import com.atlassian.confluence.plugin.helper.GroupHelper;
import com.atlassian.confluence.plugin.helper.Helper;
import com.atlassian.confluence.plugin.helper.MailServerHelper;
import com.atlassian.confluence.plugin.helper.PageHelper;
import com.atlassian.confluence.plugin.helper.SpaceHelper;
import com.atlassian.confluence.plugin.helper.UserHelper;
import com.meterware.httpunit.HttpUnitOptions;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import net.sourceforge.jwebunit.TestContext;
import net.sourceforge.jwebunit.WebTestCase;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class AbstractConfluencePluginWebTestCase
extends WebTestCase {
    public AbstractConfluencePluginWebTestCase() {
        this.tester = this.createConfluenceWebTester();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLicense() throws IOException {
        String string;
        URL licenseResource = ((Object)((Object)this)).getClass().getClassLoader().getResource("license.txt");
        BufferedReader reader = null;
        if (null == licenseResource) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter();
            reader = new BufferedReader(new InputStreamReader(licenseResource.openStream(), "UTF-8"));
            IOUtils.copy((Reader)reader, (Writer)writer);
            string = ((Object)writer).toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    protected WebTester createConfluenceWebTester() {
        ConfluenceWebTester confluenceWebTester;
        BufferedInputStream in = null;
        try {
            Properties webtesterProperties = new Properties();
            in = new BufferedInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("webtester.properties"));
            webtesterProperties.load(in);
            ConfluenceWebTester confluenceWebTester2 = new ConfluenceWebTester();
            confluenceWebTester2.setAdminUserName(webtesterProperties.getProperty("confluence.auth.admin.username"));
            confluenceWebTester2.setAdminPassword(webtesterProperties.getProperty("confluence.auth.admin.password"));
            confluenceWebTester2.setProtocol(webtesterProperties.getProperty("confluence.webapp.protocol"));
            confluenceWebTester2.setHostName(webtesterProperties.getProperty("confluence.webapp.host"));
            confluenceWebTester2.setPort(Integer.parseInt(webtesterProperties.getProperty("confluence.webapp.port")));
            confluenceWebTester2.setContextPath(webtesterProperties.getProperty("confluence.webapp.context.path"));
            confluenceWebTester2.setSoapServicePath(webtesterProperties.getProperty("confluence.webapp.soap.path"));
            if (StringUtils.isNotBlank((String)webtesterProperties.getProperty("confluence.plugin.jar")) && StringUtils.isNotBlank((String)webtesterProperties.getProperty("confluence.plugin.name"))) {
                confluenceWebTester2.setConfluencePluginJar(new File(webtesterProperties.getProperty("confluence.plugin.jar")));
                confluenceWebTester2.setConfluencePluginName(webtesterProperties.getProperty("confluence.plugin.name"));
            }
            if (StringUtils.isNotBlank((String)webtesterProperties.getProperty("confluence.data.export"))) {
                confluenceWebTester2.setConfluenceBackupZip(new File(webtesterProperties.getProperty("confluence.data.export")));
            }
            confluenceWebTester2.setLicenseString(this.getLicense());
            confluenceWebTester = confluenceWebTester2;
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException(ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return confluenceWebTester;
    }

    protected void setUp() throws Exception {
        ConfluenceWebTester confluenceWebTester = this.getConfluenceWebTester();
        super.setUp();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        TestContext testContext = this.getTestContext();
        testContext.setBaseUrl(confluenceWebTester.getBaseUrl());
        this.beginAt("");
        this.login(confluenceWebTester.getAdminUserName(), confluenceWebTester.getAdminPassword());
        this.installPlugin();
        this.updateLicense();
        this.restoreData();
    }

    protected void tearDown() throws Exception {
        this.logout();
        super.tearDown();
    }

    protected ConfluenceWebTester getConfluenceWebTester() {
        return (ConfluenceWebTester)this.tester;
    }

    protected void login(String username, String password) {
        this.getConfluenceWebTester().login(username, password);
    }

    protected void login() {
        this.getConfluenceWebTester().login();
    }

    protected void loginAsAdmin() {
        this.getConfluenceWebTester().login(this.getConfluenceWebTester().getAdminUserName(), this.getConfluenceWebTester().getAdminPassword());
    }

    protected void logout() {
        this.getConfluenceWebTester().logout();
    }

    public void updateLicense() throws IOException {
        this.getConfluenceWebTester().updateLicense();
    }

    public void refreshLicense() {
        this.getConfluenceWebTester().refreshLicense();
    }

    public void installPlugin() {
        this.getConfluenceWebTester().installPlugin();
    }

    public void restoreData() {
        this.getConfluenceWebTester().restoreData();
    }

    public void flushCaches() {
        this.getConfluenceWebTester().flushCaches();
    }

    public void reindex() {
        this.getConfluenceWebTester().reindex();
    }

    protected void assignWebTesterToHelper(Helper helper) {
        helper.setConfluenceWebTester(this.getConfluenceWebTester());
    }

    public PageHelper getPageHelper(long pageId) {
        return this.getConfluenceWebTester().getPageHelper(pageId);
    }

    public PageHelper getPageHelper() {
        return this.getConfluenceWebTester().getPageHelper();
    }

    public BlogPostHelper getBlogPostHelper(long blogPostId) {
        return this.getConfluenceWebTester().getBlogPostHelper(blogPostId);
    }

    public BlogPostHelper getBlogPostHelper() {
        return this.getConfluenceWebTester().getBlogPostHelper();
    }

    public SpaceHelper getSpaceHelper(String spaceKey) {
        return this.getConfluenceWebTester().getSpaceHelper(spaceKey);
    }

    public SpaceHelper getSpaceHelper() {
        return this.getConfluenceWebTester().getSpaceHelper();
    }

    public CommentHelper getCommentHelper(long commentId) {
        return this.getConfluenceWebTester().getCommentHelper(commentId);
    }

    public CommentHelper getCommentHelper() {
        return this.getConfluenceWebTester().getCommentHelper();
    }

    public UserHelper getUserHelper(String userName) {
        return this.getConfluenceWebTester().getUserHelper(userName);
    }

    public UserHelper getUserHelper() {
        return this.getConfluenceWebTester().getUserHelper();
    }

    public GroupHelper getGroupHelper(String groupName) {
        return this.getConfluenceWebTester().getGroupHelper(groupName);
    }

    public GroupHelper getGroupHelper() {
        return this.getConfluenceWebTester().getGroupHelper();
    }

    public MailServerHelper getMailServerHelper(long id) {
        return this.getConfluenceWebTester().getMailServerHelper(id);
    }

    public MailServerHelper getMailServerHelper() {
        return this.getConfluenceWebTester().getMailServerHelper();
    }

    public AttachmentHelper getAttachmentHelper() {
        return this.getConfluenceWebTester().getAttachmentHelper();
    }

    public AttachmentHelper getAttachmentHelper(long id, String fileName) {
        return this.getConfluenceWebTester().getAttachmentHelper(id, fileName);
    }

    public BandanaHelper getBandanaHelper(String spaceKey, String bandanaKey) {
        return this.getConfluenceWebTester().getBandanaHelper(spaceKey, bandanaKey);
    }

    public BandanaHelper getBandanaHelper(String bandanaKey) {
        return this.getConfluenceWebTester().getBandanaHelper(bandanaKey);
    }

    public BandanaHelper getBandanaHelper() {
        return this.getConfluenceWebTester().getBandanaHelper();
    }
}

