package com.atlassian.confluence.plugin.helper;

import com.atlassian.confluence.ConfluenceSoapService;
import com.atlassian.confluence.RemoteUser;

import javax.xml.rpc.ServiceException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Iterator;

public class UserHelper extends AbstractHelper {

    private String name;

    private String fullName;

    private String emailAddress;

    private String password;

    private List groups;

    public UserHelper(final String name) {
        setName(name);
        setGroups(new ArrayList());
    }

    public UserHelper() {
        this(null);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmailAddress() {
        return emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List getGroups() {
        return groups;
    }

    public void setGroups(List groups) {
        this.groups = groups;
    }

    protected RemoteUser toRemoteUser() {
        final RemoteUser remoteUser = new RemoteUser();

        remoteUser.setName(getName());
        remoteUser.setFullname(getFullName());
        remoteUser.setEmail(getEmailAddress());

        return remoteUser;
    }

    protected void populateHelper(final RemoteUser remoteUser) {
        setName(remoteUser.getName());
        setFullName(remoteUser.getFullname());
        setEmailAddress(remoteUser.getEmail());
    }

    protected void addUserToGroups(
            final String soapSessionToken,
            final ConfluenceSoapService confluenceSoapService) throws RemoteException {
        for (final Iterator i = getGroups().iterator(); i.hasNext();)
            confluenceSoapService.addUserToGroup(soapSessionToken, getName(), (String) i.next());
    }
    
    protected void removeUserGroups(
            final String soapSessionToken,
            final ConfluenceSoapService confluenceSoapService) throws RemoteException {
        for (final Iterator i = Arrays.asList(confluenceSoapService.getUserGroups(soapSessionToken, getName())).iterator(); i.hasNext();)
            confluenceSoapService.removeUserFromGroup(soapSessionToken, getName(), (String) i.next());
    }

    public boolean create() {
        String soapSessionToken = null;
        ConfluenceSoapService confluenceSoapService;

        try {
            soapSessionToken = confluenceWebTester.loginToSoapService();
            confluenceSoapService = confluenceWebTester.getConfluenceSoapService();

            confluenceSoapService.addUser(soapSessionToken, toRemoteUser(), getPassword());
            addUserToGroups(soapSessionToken, confluenceSoapService);
            return true;

        } catch (final MalformedURLException mUrlE) {
            handleInvalidSoapServiceEndpointException(mUrlE);
        } catch (final ServiceException se) {
            handleInvalidSoapServiceException(se);
        } catch (final RemoteException re) {
            handleRemoteException(re);
        } finally {
            confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }

        return false;
    }

    public boolean updatePassword() {
        String soapSessionToken = null;
        ConfluenceSoapService confluenceSoapService;

        try {
            soapSessionToken = confluenceWebTester.loginToSoapService();
            confluenceSoapService = confluenceWebTester.getConfluenceSoapService();

            return confluenceSoapService.changeUserPassword(soapSessionToken, getName(), getPassword());

        } catch (final MalformedURLException mUrlE) {
            handleInvalidSoapServiceEndpointException(mUrlE);
        } catch (final ServiceException se) {
            handleInvalidSoapServiceException(se);
        } catch (final RemoteException re) {
            handleRemoteException(re);
        } finally {
            confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }

        return false;
    }

    public boolean read() {
        String soapSessionToken = null;
        ConfluenceSoapService confluenceSoapService;

        try {
            soapSessionToken = confluenceWebTester.loginToSoapService();
            confluenceSoapService = confluenceWebTester.getConfluenceSoapService();

            populateHelper(confluenceSoapService.getUser(soapSessionToken, getName()));
            setGroups(Arrays.asList(confluenceSoapService.getUserGroups(soapSessionToken, getName())));

            return true;

        } catch (final MalformedURLException mUrlE) {
            handleInvalidSoapServiceEndpointException(mUrlE);
        } catch (final ServiceException se) {
            handleInvalidSoapServiceException(se);
        } catch (final RemoteException re) {
            handleRemoteException(re);
        } finally {
            confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }

        return false;
    }

    public boolean update() {
        String soapSessionToken = null;
        ConfluenceSoapService confluenceSoapService;

        try {
            soapSessionToken = confluenceWebTester.loginToSoapService();
            confluenceSoapService = confluenceWebTester.getConfluenceSoapService();

            confluenceSoapService.editUser(soapSessionToken, toRemoteUser());
            removeUserGroups(soapSessionToken, confluenceSoapService);
            addUserToGroups(soapSessionToken, confluenceSoapService);
            return true;

        } catch (final MalformedURLException mUrlE) {
            handleInvalidSoapServiceEndpointException(mUrlE);
        } catch (final ServiceException se) {
            handleInvalidSoapServiceException(se);
        } catch (final RemoteException re) {
            handleRemoteException(re);
        } finally {
            confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }

        return false;
    }

    public boolean delete() {
        String soapSessionToken = null;
        ConfluenceSoapService confluenceSoapService;

        try {
            soapSessionToken = confluenceWebTester.loginToSoapService();
            confluenceSoapService = confluenceWebTester.getConfluenceSoapService();

            return confluenceSoapService.removeUser(soapSessionToken, getName());
            
        } catch (final MalformedURLException mUrlE) {
            handleInvalidSoapServiceEndpointException(mUrlE);
        } catch (final ServiceException se) {
            handleInvalidSoapServiceException(se);
        } catch (final RemoteException re) {
            handleRemoteException(re);
        } finally {
            confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }

        return false;
    }
}
