package com.atlassian.confluence.plugin;

import com.atlassian.confluence.plugin.helper.*;
import com.meterware.httpunit.HttpUnitOptions;
import net.sourceforge.jwebunit.TestContext;
import net.sourceforge.jwebunit.WebTestCase;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

import java.io.*;
import java.net.URL;
import java.util.Properties;

public class AbstractConfluencePluginWebTestCase extends WebTestCase {

    public AbstractConfluencePluginWebTestCase() {
        super();
        tester = createConfluenceWebTester();
    }

    protected String getLicense() throws IOException {
        URL licenseResource = getClass().getClassLoader().getResource("license.txt");
        Reader reader = null;

        if (null == licenseResource)
            return null;

        try {
            final Writer writer = new StringWriter();

            reader = new BufferedReader(new InputStreamReader(licenseResource.openStream(), "UTF-8"));
            IOUtils.copy(reader, writer);

            return writer.toString();

        } finally {
            IOUtils.closeQuietly(reader);
        }
    }

    protected WebTester createConfluenceWebTester() {
        InputStream in = null;

        try {
            final Properties webtesterProperties = new Properties();
            final ConfluenceWebTester confluenceWebTester;

            in = new BufferedInputStream(getClass().getClassLoader().getResourceAsStream("webtester.properties"));

            webtesterProperties.load(in);

            confluenceWebTester = new ConfluenceWebTester();

            confluenceWebTester.setAdminUserName(webtesterProperties.getProperty("confluence.auth.admin.username"));
            confluenceWebTester.setAdminPassword(webtesterProperties.getProperty("confluence.auth.admin.password"));

            confluenceWebTester.setProtocol(webtesterProperties.getProperty("confluence.webapp.protocol"));
            confluenceWebTester.setHostName(webtesterProperties.getProperty("confluence.webapp.host"));
            confluenceWebTester.setPort(Integer.parseInt(webtesterProperties.getProperty("confluence.webapp.port")));
            confluenceWebTester.setContextPath(webtesterProperties.getProperty("confluence.webapp.context.path"));
            confluenceWebTester.setSoapServicePath(webtesterProperties.getProperty("confluence.webapp.soap.path"));

            if (StringUtils.isNotBlank(webtesterProperties.getProperty("confluence.plugin.jar"))
                    && StringUtils.isNotBlank(webtesterProperties.getProperty("confluence.plugin.name"))) {
                confluenceWebTester.setConfluencePluginJar(new File(webtesterProperties.getProperty("confluence.plugin.jar")));
                confluenceWebTester.setConfluencePluginName(webtesterProperties.getProperty("confluence.plugin.name"));
            }

            if (StringUtils.isNotBlank(webtesterProperties.getProperty("confluence.data.export"))) {
                confluenceWebTester.setConfluenceBackupZip(new File(webtesterProperties.getProperty("confluence.data.export")));
            }

            confluenceWebTester.setLicenseString(getLicense());
            return confluenceWebTester;
            
        } catch (final IOException ioe) {
            throw new RuntimeException(ioe);
        } finally {
            IOUtils.closeQuietly(in);
        }
    }

    protected void setUp() throws Exception {
        final ConfluenceWebTester confluenceWebTester = getConfluenceWebTester();
        final TestContext testContext;

        super.setUp();

        HttpUnitOptions.setScriptingEnabled(false);
        
        testContext = getTestContext();
        testContext.setBaseUrl(confluenceWebTester.getBaseUrl());


        beginAt(StringUtils.EMPTY);

        login(confluenceWebTester.getAdminUserName(), confluenceWebTester.getAdminPassword());
        installPlugin();
        updateLicense();
        restoreData();
    }

    protected void tearDown() throws Exception {
        logout();
        super.tearDown();
    }

    protected ConfluenceWebTester getConfluenceWebTester() {
        return (ConfluenceWebTester) tester;
    }

    protected void login(String username, String password) {
        getConfluenceWebTester().login(username, password);
    }

    protected void login() {
        getConfluenceWebTester().login();
    }

    protected void loginAsAdmin() {
        getConfluenceWebTester().login(getConfluenceWebTester().getAdminUserName(), getConfluenceWebTester().getAdminPassword());
    }

    protected void logout() {
        getConfluenceWebTester().logout();
    }

    public void updateLicense() throws IOException {
        getConfluenceWebTester().updateLicense();
    }

    public void refreshLicense() {
        getConfluenceWebTester().refreshLicense();
    }

    public void installPlugin() {
        getConfluenceWebTester().installPlugin();
    }

    public void restoreData() {
        getConfluenceWebTester().restoreData();
    }

    public void flushCaches() {
        getConfluenceWebTester().flushCaches();
    }

    public void reindex() {
        getConfluenceWebTester().reindex();
    }

    protected void assignWebTesterToHelper(final Helper helper) {
        helper.setConfluenceWebTester(getConfluenceWebTester());
    }

    public PageHelper getPageHelper(long pageId) {
        return getConfluenceWebTester().getPageHelper(pageId);
    }

    public PageHelper getPageHelper() {
        return getConfluenceWebTester().getPageHelper();
    }

    public BlogPostHelper getBlogPostHelper(long blogPostId) {
        return getConfluenceWebTester().getBlogPostHelper(blogPostId);
    }

    public BlogPostHelper getBlogPostHelper() {
        return getConfluenceWebTester().getBlogPostHelper();
    }

    public SpaceHelper getSpaceHelper(String spaceKey) {
        return getConfluenceWebTester().getSpaceHelper(spaceKey);
    }

    public SpaceHelper getSpaceHelper() {
        return getConfluenceWebTester().getSpaceHelper();
    }

    public CommentHelper getCommentHelper(long commentId) {
        return getConfluenceWebTester().getCommentHelper(commentId);
    }

    public CommentHelper getCommentHelper() {
        return getConfluenceWebTester().getCommentHelper();
    }

    public UserHelper getUserHelper(String userName) {
        return getConfluenceWebTester().getUserHelper(userName);
    }

    public UserHelper getUserHelper() {
        return getConfluenceWebTester().getUserHelper();
    }

    public GroupHelper getGroupHelper(String groupName) {
        return getConfluenceWebTester().getGroupHelper(groupName);
    }

    public GroupHelper getGroupHelper() {
        return getConfluenceWebTester().getGroupHelper();
    }

    public MailServerHelper getMailServerHelper(long id) {
        return getConfluenceWebTester().getMailServerHelper(id);
    }

    public MailServerHelper getMailServerHelper() {
        return getConfluenceWebTester().getMailServerHelper();
    }

    public AttachmentHelper getAttachmentHelper() {
        return getConfluenceWebTester().getAttachmentHelper();
    }

    public AttachmentHelper getAttachmentHelper(long id, String fileName) {
        return getConfluenceWebTester().getAttachmentHelper(id, fileName);
    }

    public BandanaHelper getBandanaHelper(String spaceKey, String bandanaKey) {
        return getConfluenceWebTester().getBandanaHelper(spaceKey, bandanaKey);
    }

    public BandanaHelper getBandanaHelper(String bandanaKey) {
        return getConfluenceWebTester().getBandanaHelper(bandanaKey);
    }

    public BandanaHelper getBandanaHelper() {
        return getConfluenceWebTester().getBandanaHelper();
    }
}
