/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.officeconnector.index.excel;

import com.atlassian.bonnie.search.Extractor;
import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.BaseAttachmentContentExtractor;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.confluence.extra.office.OfficeFile;
import com.atlassian.confluence.extra.officeconnector.index.util.AbstractLengthLimitedStringBuilder;
import com.atlassian.confluence.extra.officeconnector.index.util.AttachmentTextExtractorAdapter;
import com.atlassian.confluence.extra.officeconnector.index.util.LimitReachedException;
import com.atlassian.confluence.extra.officeconnector.index.util.StaticLengthLimitedStringBuilder;
import com.atlassian.confluence.index.attachment.AttachmentTextExtractor;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.util.io.InputStreamSource;
import com.atlassian.security.xml.SecureXmlParserFactory;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExcelXMLTextExtractor
extends BaseAttachmentContentExtractor
implements AttachmentTextExtractor {
    private static final Logger log = LoggerFactory.getLogger(ExcelXMLTextExtractor.class);
    private static final String[] CONTENT_TYPES = OfficeFile.getMimeTypesFor((OfficeFile.Type)OfficeFile.Type.Excel, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    private static final String[] EXTENSIONS = OfficeFile.getExtensionsFor((OfficeFile.Type)OfficeFile.Type.Excel, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    public static final String MAX_LENGTH_PROPERTY = "officeconnector.excel.extractor.maxlength";
    public static final int DEFAULT_MAX_LENGTH = 0x100000;

    public List<String> getFileExtensions() {
        return Arrays.asList(EXTENSIONS);
    }

    public List<String> getMimeTypes() {
        return Arrays.asList(CONTENT_TYPES);
    }

    public Optional<InputStreamSource> extract(Attachment attachment) {
        return new AttachmentTextExtractorAdapter((Extractor)this).apply(attachment);
    }

    protected String extractText(InputStream is, SearchableAttachment attachment) throws ExtractorException {
        SAXParser parser;
        try {
            SAXParserFactory spf = SecureXmlParserFactory.createSAXParserFactory();
            parser = spf.newSAXParser();
        }
        catch (Exception e) {
            throw new ExtractorException("could not create SAX parser", (Throwable)e);
        }
        try {
            ZipEntry ze;
            UtilTimerStack.push((String)"extractText() -- Pass 1 - Read shared strings");
            ZipInputStream zin = new ZipInputStream(attachment.getContentsAsStream());
            ArrayList<String> strings = new ArrayList<String>();
            while ((ze = zin.getNextEntry()) != null) {
                parser.reset();
                if (!ze.getName().equals("xl/sharedStrings.xml")) continue;
                try {
                    this.parseSharedStrings(parser, ze, zin, strings);
                }
                catch (LimitReachedException e) {
                    log.info("Not enough memory to read '{}'. The attachment won't be searchable.", (Object)attachment.getFileName());
                    return "";
                }
            }
            zin.close();
            UtilTimerStack.pop((String)"extractText() -- Pass 1 - Read shared strings");
            UtilTimerStack.push((String)"extractText() -- Pass 2 - Build output string");
            zin = new ZipInputStream(attachment.getContentsAsStream());
            StaticLengthLimitedStringBuilder outputBuffer = new StaticLengthLimitedStringBuilder(this.getMaxLength());
            while ((ze = zin.getNextEntry()) != null) {
                parser.reset();
                if (ze.getName().equals("xl/sharedStrings.xml")) continue;
                this.parseEntry(parser, ze, zin, outputBuffer, strings);
            }
            zin.close();
            UtilTimerStack.pop((String)"extractText() -- Pass 2 - Build output string");
            if (outputBuffer.isLimitReached()) {
                log.info("Not enough memory to extract all text from '{}'. The attachment will be partially searchable.", (Object)attachment.getFileName());
            }
            return outputBuffer.toString();
        }
        catch (IOException e) {
            throw new ExtractorException("Error reading content of Excel document: " + e.getMessage(), (Throwable)e);
        }
    }

    private void parseSharedStrings(SAXParser parser, ZipEntry ze, final ZipInputStream zin, ArrayList<String> strings) throws ExtractorException {
        log.debug("parsing shared strings [ {} ]", (Object)ze.getName());
        BufferedInputStream in = new BufferedInputStream(zin){

            @Override
            public void close() throws IOException {
                zin.closeEntry();
            }
        };
        try {
            SharedStringsHandler sharedStringsHandler = new SharedStringsHandler(strings);
            parser.parse((InputStream)in, (DefaultHandler)sharedStringsHandler);
        }
        catch (LimitReachedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExtractorException("Could not create SAX Parser", (Throwable)e);
        }
    }

    private void parseEntry(SAXParser parser, ZipEntry ze, final ZipInputStream zin, AbstractLengthLimitedStringBuilder outputBuffer, List<String> strings) throws ExtractorException {
        if (!ze.getName().endsWith(".xml")) {
            log.debug("skipping [ {} ]", (Object)ze.getName());
            return;
        }
        log.debug("parsing [ {} ]", (Object)ze.getName());
        try {
            BufferedInputStream in = new BufferedInputStream(zin){

                @Override
                public void close() throws IOException {
                    zin.closeEntry();
                }
            };
            parser.parse((InputStream)in, (DefaultHandler)new PartHandler(outputBuffer, strings));
        }
        catch (Exception e) {
            throw new ExtractorException("Could not create SAX Parser", (Throwable)e);
        }
    }

    protected String[] getMatchingContentTypes() {
        return CONTENT_TYPES;
    }

    protected String[] getMatchingFileExtensions() {
        return EXTENSIONS;
    }

    int getMaxLength() {
        int maxLength = 0x100000;
        String maxLengthProperty = System.getProperty(MAX_LENGTH_PROPERTY);
        if (maxLengthProperty != null) {
            try {
                maxLength = Integer.parseInt(maxLengthProperty);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse property officeconnector.excel.extractor.maxlength", (Throwable)e);
            }
        }
        return maxLength / 2;
    }

    private class SharedStringsHandler
    extends DefaultHandler {
        private boolean capturingString = false;
        private boolean capturingStringPart = false;
        private final ArrayList<String> strings;
        private final StringBuilder buffer;
        private int uniqueCount;

        public SharedStringsHandler(ArrayList<String> strings) {
            this.strings = strings;
            this.buffer = new StringBuilder();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("si")) {
                this.capturingString = true;
            }
            if (this.capturingString && qName.equals("t")) {
                this.capturingStringPart = true;
            } else if (qName.equals("t")) {
                log.error("expected <si> before <t>");
            }
            if (qName.equals("sst")) {
                this.uniqueCount = Integer.valueOf(attributes.getValue("uniqueCount"));
                this.strings.ensureCapacity(this.uniqueCount);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.capturingStringPart) {
                this.buffer.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("t")) {
                this.capturingStringPart = false;
            }
            if (qName.equals("si")) {
                this.strings.add(this.buffer.toString());
                this.buffer.setLength(0);
                this.capturingString = false;
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.strings.size() != this.uniqueCount) {
                log.error("expected [ {} ] entries but read [ {} ]", (Object)this.uniqueCount, (Object)this.strings.size());
            } else {
                log.debug("read [ {} ] shared strings", (Object)this.strings.size());
            }
        }
    }

    private class PartHandler
    extends DefaultHandler {
        private final AbstractLengthLimitedStringBuilder outputBuffer;
        private List<String> strings;
        private String capturingElement = null;
        private CapturingType type = null;
        private StringBuilder buffer = new StringBuilder();

        public PartHandler(AbstractLengthLimitedStringBuilder outputBuffer, List<String> strings) {
            this.outputBuffer = outputBuffer;
            this.strings = strings;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("c") || qName.equals("si")) {
                this.type = "s".equals(attributes.getValue("t")) ? CapturingType.INDEXED : CapturingType.LITERAL;
                log.debug("capturing [ {} ]", (Object)qName);
                this.capturingElement = qName;
            } else if (qName.equals("sheet")) {
                this.appendToOutput(attributes.getValue("name"));
            } else {
                log.debug("skipping [ {} ]", (Object)qName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.capturingElement != null) {
                this.buffer.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.capturingElement != null && qName.equals(this.capturingElement)) {
                this.capturingElement = null;
                switch (this.type) {
                    case INDEXED: {
                        int index = Integer.parseInt(this.buffer.toString());
                        this.appendToOutput(this.strings.get(index));
                        break;
                    }
                    case LITERAL: {
                        this.appendToOutput(this.buffer.toString());
                    }
                }
                this.type = null;
                this.buffer.setLength(0);
            }
        }

        private void appendToOutput(String s) {
            this.outputBuffer.append(' ').append(s);
        }
    }

    private static enum CapturingType {
        INDEXED,
        LITERAL;

    }
}

