/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.officeconnector.index.word;

import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.confluence.extra.office.OfficeFile;
import com.atlassian.confluence.index.attachment.AttachmentTextExtractor;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugins.conversion.extract.binary.WordBinaryExtractor;
import com.atlassian.confluence.util.io.InputStreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public class WordTextExtractor
implements AttachmentTextExtractor {
    private static final String[] CONTENT_TYPES = OfficeFile.getMimeTypesFor((OfficeFile.Type)OfficeFile.Type.Word, (OfficeFile.Version)OfficeFile.Version.V97).toArray(new String[0]);
    private static final String[] EXTENSIONS = OfficeFile.getExtensionsFor((OfficeFile.Type)OfficeFile.Type.Word, (OfficeFile.Version)OfficeFile.Version.V97).toArray(new String[0]);
    private final AttachmentManager attachmentManager;

    public WordTextExtractor(AttachmentManager attachmentManager) {
        this.attachmentManager = Objects.requireNonNull(attachmentManager);
    }

    public List<String> getFileExtensions() {
        return Arrays.asList(EXTENSIONS);
    }

    public List<String> getMimeTypes() {
        return Arrays.asList(CONTENT_TYPES);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<InputStreamSource> extract(Attachment attachment) {
        try (InputStream is = this.attachmentManager.getAttachmentData(attachment);){
            if (is == null) {
                Optional<InputStreamSource> optional2 = Optional.empty();
                return optional2;
            }
            String text = this.extractText(is);
            Optional<InputStreamSource> optional = Optional.of(() -> IOUtils.toInputStream((String)text, (Charset)StandardCharsets.UTF_8));
            return optional;
        }
        catch (ExtractorException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String extractText(InputStream inputStream) throws ExtractorException {
        return WordBinaryExtractor.extractText((InputStream)inputStream);
    }
}

