/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.officeconnector.index.powerpoint;

import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.confluence.extra.office.OfficeFile;
import com.atlassian.confluence.extra.officeconnector.index.AbstractAttachmentExtractor;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugins.conversion.extract.xml.SlidesXMLExtractor;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerPointXMLTextExtractor
extends AbstractAttachmentExtractor {
    private static final Logger log = LoggerFactory.getLogger(PowerPointXMLTextExtractor.class);
    private static final String[] CONTENT_TYPES = OfficeFile.getMimeTypesFor((OfficeFile.Type)OfficeFile.Type.PowerPoint, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    private static final String[] EXTENSIONS = OfficeFile.getExtensionsFor((OfficeFile.Type)OfficeFile.Type.PowerPoint, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    public static final String MAX_LENGTH_PROPERTY = "officeconnector.powerpoint.extractor.maxlength";
    public static final int DEFAULT_MAX_LENGTH = 0x100000;
    private final AttachmentManager attachmentManager;

    public PowerPointXMLTextExtractor(AttachmentManager attachmentManager) {
        this.attachmentManager = Objects.requireNonNull(attachmentManager);
    }

    public List<String> getFileExtensions() {
        return Arrays.asList(EXTENSIONS);
    }

    public List<String> getMimeTypes() {
        return Arrays.asList(CONTENT_TYPES);
    }

    @Override
    protected AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    @Override
    protected String extractText(InputStream is) throws ExtractorException {
        return SlidesXMLExtractor.extractText((InputStream)is, (long)this.getMaxLength());
    }

    int getMaxLength() {
        int maxLength = 0x100000;
        String maxLengthProperty = System.getProperty(MAX_LENGTH_PROPERTY);
        if (maxLengthProperty != null) {
            try {
                maxLength = Integer.parseInt(maxLengthProperty);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse property {}", (Object)MAX_LENGTH_PROPERTY, (Object)e);
            }
        }
        return maxLength / 2;
    }
}

