/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.officeconnector.index.excel;

import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.confluence.extra.office.OfficeFile;
import com.atlassian.confluence.index.attachment.AttachmentTextExtractor;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugins.conversion.extract.xml.SpreadsheetXMLExtractor;
import com.atlassian.confluence.util.io.InputStreamSource;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelXMLTextExtractor
implements AttachmentTextExtractor {
    private static final Logger log = LoggerFactory.getLogger(ExcelXMLTextExtractor.class);
    private static final String[] CONTENT_TYPES = OfficeFile.getMimeTypesFor((OfficeFile.Type)OfficeFile.Type.Excel, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    private static final String[] EXTENSIONS = OfficeFile.getExtensionsFor((OfficeFile.Type)OfficeFile.Type.Excel, (OfficeFile.Version)OfficeFile.Version.V2007).toArray(new String[0]);
    public static final String MAX_LENGTH_PROPERTY = "officeconnector.excel.extractor.maxlength";
    public static final int DEFAULT_MAX_LENGTH = 0x100000;
    private final AttachmentManager attachmentManager;

    public ExcelXMLTextExtractor(AttachmentManager attachmentManager) {
        this.attachmentManager = Objects.requireNonNull(attachmentManager);
    }

    public List<String> getFileExtensions() {
        return Arrays.asList(EXTENSIONS);
    }

    public List<String> getMimeTypes() {
        return Arrays.asList(CONTENT_TYPES);
    }

    public Optional<InputStreamSource> extract(Attachment attachment) {
        return Optional.of(() -> {
            try {
                return IOUtils.toInputStream((String)this.extractText(attachment), (Charset)StandardCharsets.UTF_8);
            }
            catch (ExtractorException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private String extractText(Attachment attachment) throws ExtractorException {
        InputStream is = this.attachmentManager.getAttachmentData(attachment);
        return SpreadsheetXMLExtractor.extractText((InputStream)is, (int)this.getMaxLength(), (Attachment)attachment);
    }

    int getMaxLength() {
        int maxLength = 0x100000;
        String maxLengthProperty = System.getProperty(MAX_LENGTH_PROPERTY);
        if (maxLengthProperty != null) {
            try {
                maxLength = Integer.parseInt(maxLengthProperty);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse property {}", (Object)MAX_LENGTH_PROPERTY, (Object)e);
            }
        }
        return maxLength / 2;
    }
}

