/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.officeconnector.index.excel;

import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.confluence.extra.office.OfficeFile;
import com.atlassian.confluence.extra.officeconnector.index.AbstractAttachmentExtractor;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugins.conversion.extract.binary.SpreadsheetBinaryExtractor;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ExcelTextExtractor
extends AbstractAttachmentExtractor {
    private static final String[] CONTENT_TYPES = OfficeFile.getMimeTypesFor((OfficeFile.Type)OfficeFile.Type.Excel, (OfficeFile.Version)OfficeFile.Version.V97).toArray(new String[0]);
    private static final String[] EXTENSIONS = OfficeFile.getExtensionsFor((OfficeFile.Type)OfficeFile.Type.Excel, (OfficeFile.Version)OfficeFile.Version.V97).toArray(new String[0]);
    private final AttachmentManager attachmentManager;

    public ExcelTextExtractor(AttachmentManager attachmentManager) {
        this.attachmentManager = Objects.requireNonNull(attachmentManager);
    }

    public List<String> getFileExtensions() {
        return Arrays.asList(EXTENSIONS);
    }

    public List<String> getMimeTypes() {
        return Arrays.asList(CONTENT_TYPES);
    }

    @Override
    protected AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    @Override
    protected String extractText(InputStream is) throws ExtractorException {
        return SpreadsheetBinaryExtractor.extractText((InputStream)is);
    }
}

