/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.webwork;

import com.atlassian.confluence.extra.office.canary.aspose.words.WordImportCanaryExecutor;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.actions.ViewPageAction;
import com.atlassian.confluence.plugins.conversion.dom.DefaultImportContext;
import com.atlassian.confluence.plugins.conversion.dom.DefaultSplitImportContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.core.util.FileSize;
import com.atlassian.fugue.Maybe;
import com.atlassian.plugins.conversion.confluence.dom.ImageSizeException;
import com.atlassian.plugins.conversion.confluence.dom.ImportContext;
import com.atlassian.plugins.conversion.confluence.dom.doc2wiki.splitter.BookmarkInfo;
import com.atlassian.plugins.conversion.confluence.dom.doc2wiki.splitter.DocumentTreeNode;
import com.atlassian.plugins.conversion.confluence.dom.doc2wiki.splitter.SplitImportContext;
import com.atlassian.plugins.conversion.confluence.importing.WordImport;
import com.atlassian.user.User;
import com.atlassian.xwork.RequireSecurityToken;
import com.benryan.components.AutoCloseableSemaphore;
import com.benryan.components.ImporterSemaphore;
import com.benryan.components.OcSettingsManager;
import com.benryan.dom.ImportTitleResolver;
import com.benryan.webwork.DocumentToLargeException;
import com.benryan.webwork.InvalidDocumentException;
import com.benryan.webwork.WordImportInfo;
import com.benryan.webwork.util.PageNames;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import com.opensymphony.webwork.interceptor.SessionAware;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordImportAction
extends ViewPageAction
implements ServletRequestAware,
SessionAware {
    private static final Logger log = LoggerFactory.getLogger(WordImportAction.class);
    private static final String FILE_KEY = "wordImportFile";
    private static final String BOOKMARKS_KEY = "wordImportBookmarks";
    private static final String TREE_KEY = "wordImportRoot";
    private static final String NODES_KEY = "wordImportNodes";
    public static final String WARNING = "warning";
    private static final Pattern CONTENT_LENGTH_MESSAGE_PATTERN = Pattern.compile("java\\.io\\.IOException: Content Length Error \\((\\p{Digit}+) > (\\p{Digit}+)\\)");
    HttpServletRequest _request;
    Map _session;
    DocumentTreeNode<Page> _treeRoot;
    BookmarkInfo _bookmarks;
    String _pageTitle;
    int _treeDepth;
    WordImportInfo _importInfo = new WordImportInfo();
    List<DocumentTreeNode<Page>> _orderedNodes;
    AttachmentManager _attachmentManager;
    List<String> _pagesBeingDeleted;
    List<String> _pagesBeingOverwritten;
    List<String> _pagesBeingCreated;
    private boolean _advanced;
    private OcSettingsManager ocSettingsManager;
    private XsrfTokenService xsrfTokenService;
    private WordImportCanaryExecutor canaryCage;
    private ImporterSemaphore importerSemaphore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeFileUpload() throws Exception {
        String string;
        MultiPartRequestWrapper request = (MultiPartRequestWrapper)this._request;
        File file = null;
        String fileName = null;
        try {
            Object xsrfValidationErrorMessage;
            Maybe xsrfValidationResult;
            ArrayList errors = (ArrayList)request.getErrors();
            if (errors != null) {
                for (int i = 0; i < errors.size(); ++i) {
                    Matcher m = CONTENT_LENGTH_MESSAGE_PATTERN.matcher((String)errors.get(i));
                    if (!m.matches()) continue;
                    String maxDocSize = FileSize.format((long)Long.parseLong(m.group(2)));
                    throw new DocumentToLargeException("Total document size is too large. Reduce total document size to below " + maxDocSize);
                }
            }
            if ((xsrfValidationResult = this.xsrfTokenService.validate((HttpServletRequest)request)).isDefined()) {
                xsrfValidationErrorMessage = (Message)xsrfValidationResult.get();
                super.addActionError(this.getText(xsrfValidationErrorMessage.getKey(), xsrfValidationErrorMessage.getArguments()));
                String string2 = "error";
                return string2;
            }
            file = request.getFiles("filename")[0];
            this._pageTitle = fileName = request.getFileNames("filename")[0];
            if (fileName.lastIndexOf(46) != -1) {
                this._pageTitle = fileName.substring(0, fileName.lastIndexOf(46));
            }
            if (!this.canaryCage.verify(file, fileName)) {
                this.addActionError("The uploaded file contains data which cannot be safely imported.");
                xsrfValidationErrorMessage = "error";
                return xsrfValidationErrorMessage;
            }
            log.debug("Import word document [ {} ] ", (Object)fileName);
            byte[] docBuf = this.buildDocumentTree(file, this._pageTitle);
            this._importInfo.setTreeDepth(this._treeDepth);
            this._session.put(FILE_KEY, docBuf);
            this._session.put(BOOKMARKS_KEY, this._bookmarks);
            this._session.put(NODES_KEY, this._orderedNodes);
            this._session.put(TREE_KEY, this._treeRoot);
        }
        catch (InvalidDocumentException e) {
            super.addActionError("The selected file is not a valid binary Word 97-2003 document");
            string = "error";
            return string;
        }
        catch (DocumentToLargeException e) {
            super.addActionError(e.getMessage());
            string = "error";
            return string;
        }
        catch (Exception e) {
        }
        finally {
            if (file != null && !file.delete()) {
                log.warn("Failed to delete uploaded file " + file.getAbsolutePath());
            }
        }
        if (file == null || fileName == null) {
            return "error";
        }
        String submitType = this._request.getParameter("submit");
        if (submitType != null && submitType.equals("Import")) {
            this._importInfo.setTitle(this.getPage().getTitle());
            this._importInfo.setConflict(0);
            this._importInfo.setLvl(0);
            this._importInfo.setImportSpace(false);
            return this.executeFileImport();
        }
        this._importInfo.setTitle(this._pageTitle);
        return "input";
    }

    @RequireSecurityToken(value=true)
    public String executeFileImport() throws Exception {
        try (AutoCloseableSemaphore semaphore = this.importerSemaphore.acquire();){
            String string = this.doExecuteFileImport();
            return string;
        }
    }

    private String doExecuteFileImport() throws Exception {
        this._bookmarks = (BookmarkInfo)this._session.get(BOOKMARKS_KEY);
        this._orderedNodes = (ArrayList)this._session.get(NODES_KEY);
        this._treeRoot = (DocumentTreeNode)this._session.get(TREE_KEY);
        this._pagesBeingDeleted = new ArrayList<String>();
        this._pagesBeingOverwritten = new ArrayList<String>();
        this._pagesBeingCreated = new ArrayList<String>();
        User currentUser = AuthenticatedUserThreadLocal.getUser();
        boolean failFast = this.permissionChecks(currentUser);
        if (failFast) {
            return "error";
        }
        boolean showWarning = this.shouldShowWarning();
        if (showWarning) {
            return WARNING;
        }
        if (!this.isValidTitle()) {
            return "error";
        }
        return this.doFileImport();
    }

    private boolean isValidTitle() {
        if (StringUtils.isBlank((String)this._importInfo.getTitle())) {
            this.addFieldError("docTitle", this.getText("page.title.empty"));
            return false;
        }
        return true;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.EDIT, (Object)this.getPage());
    }

    @HtmlSafe
    public String getExplanationHtml() {
        if (this._importInfo.getConflict() == 0) {
            this.conflictVersionCheck();
        }
        this.createCheck();
        StringBuffer warnBuf = new StringBuffer("Warning! You are about to ");
        if (!this._importInfo.isImportSpace()) {
            warnBuf.append("overwrite the contents of this page (");
            warnBuf.append(this.getPage().getTitle());
            warnBuf.append(")");
            if (!this._importInfo.getTitle().equals(this.getPage().getTitle())) {
                String newTitle = this._importInfo.getTitle();
                if (this.pageManager.getPage(this.getSpaceKey(), this._importInfo.getTitle()) != null) {
                    newTitle = ImportTitleResolver.getUniquePageName(newTitle, new HashSet(), this.pageManager, this.getSpaceKey());
                }
                warnBuf.append(" and change the title from \"");
                warnBuf.append(this.getPage().getTitle());
                warnBuf.append("\" to \"");
                warnBuf.append(newTitle);
                warnBuf.append("\"");
            }
            if (this._pagesBeingCreated.size() > 0 || this._pagesBeingDeleted.size() > 0 || this._pagesBeingOverwritten.size() > 0) {
                warnBuf.append(" and ");
            }
        }
        if (this._pagesBeingDeleted.size() > 0) {
            warnBuf.append(" delete the following pages");
            warnBuf.append("<ul>");
            for (int x = 0; x < this._pagesBeingDeleted.size(); ++x) {
                warnBuf.append("<li>");
                warnBuf.append(this._pagesBeingDeleted.get(x));
                warnBuf.append("</li>");
            }
            warnBuf.append("</ul>");
            if (this._pagesBeingOverwritten.size() > 0 || this._pagesBeingCreated.size() > 0) {
                warnBuf.append("and ");
            }
        }
        if (this._pagesBeingOverwritten.size() > 0) {
            warnBuf.append("overwrite the following pages");
            warnBuf.append("<ul>");
            for (int x = 0; x < this._pagesBeingOverwritten.size(); ++x) {
                warnBuf.append("<li>");
                warnBuf.append(this._pagesBeingOverwritten.get(x));
                warnBuf.append("</li>");
            }
            warnBuf.append("</ul>");
            if (this._pagesBeingCreated.size() > 0) {
                warnBuf.append(" and ");
            }
        }
        if (this._pagesBeingCreated.size() > 0) {
            warnBuf.append("create the following pages");
            warnBuf.append("<ul>");
            for (int x = 0; x < this._pagesBeingCreated.size(); ++x) {
                warnBuf.append("<li>");
                warnBuf.append(this._pagesBeingCreated.get(x));
                warnBuf.append("</li>");
            }
            warnBuf.append("</ul>");
        }
        return warnBuf.toString();
    }

    private void createCheck() {
        try {
            DocumentTreeNode root = (DocumentTreeNode)this._treeRoot.clone();
            ArrayList<DocumentTreeNode<Page>> nodes = new ArrayList<DocumentTreeNode<Page>>(this._orderedNodes.size());
            for (DocumentTreeNode<Page> _orderedNode : this._orderedNodes) {
                nodes.add((DocumentTreeNode<Page>)((DocumentTreeNode)_orderedNode.clone()));
            }
            this.resolveTitleConflicts(false, (DocumentTreeNode<Page>)root, nodes);
            if (this._importInfo.isImportSpace()) {
                this._pagesBeingCreated.add(root.getText());
            }
            for (DocumentTreeNode<Page> node : nodes) {
                if (node.getOldPage() != null || node.getLvl() > this._importInfo.getLvl()) continue;
                this._pagesBeingCreated.add(node.getText());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    private void conflictVersionCheck() {
        for (DocumentTreeNode<Page> node : this._orderedNodes) {
            String text = PageNames.fixPageTitle(node.getText());
            Page page = this.pageManager.getPage(this.getSpaceKey(), text);
            if (page == null || node.getLvl() > this._importInfo.getLvl()) continue;
            this._pagesBeingOverwritten.add(page.getTitle());
        }
    }

    public String processWarning() throws Exception {
        String submitType = this._request.getParameter("submit");
        if (submitType != null && submitType.equals("Continue")) {
            return this.doFileImport();
        }
        if (this._advanced) {
            this._bookmarks = (BookmarkInfo)this._session.get(BOOKMARKS_KEY);
            this._orderedNodes = (ArrayList)this._session.get(NODES_KEY);
            this._treeRoot = (DocumentTreeNode)this._session.get(TREE_KEY);
            this._pagesBeingDeleted = new ArrayList<String>();
            return "input";
        }
        return "success";
    }

    public String doFileImport() throws Exception {
        Page rootPage;
        byte[] docBuf = (byte[])this._session.get(FILE_KEY);
        this._bookmarks = (BookmarkInfo)this._session.get(BOOKMARKS_KEY);
        this._orderedNodes = (ArrayList)this._session.get(NODES_KEY);
        this._treeRoot = (DocumentTreeNode)this._session.get(TREE_KEY);
        this._pagesBeingDeleted = new ArrayList<String>();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (!this._importInfo.isImportSpace()) {
            Page page = (Page)this.getPage();
            this._treeRoot.setOldPage((Object)page);
            if (this._importInfo.getOverwriteAll()) {
                this.recursiveTrash(page);
            }
        }
        this.resolveTitleConflicts(true, this._treeRoot, this._orderedNodes);
        Page oldPage = (Page)this._treeRoot.getOldPage();
        if (oldPage != null) {
            rootPage = oldPage;
            oldPage = (Page)rootPage.clone();
            this._treeRoot.setOldPage((Object)oldPage);
        } else {
            rootPage = new Page();
            rootPage.setSpace(this.getSpace());
            Page homePage = super.getSpace().getHomePage();
            if (homePage != null) {
                homePage.addChild(rootPage);
            }
            rootPage.setCreator(currentUser);
        }
        rootPage.setTitle(this._treeRoot.getText());
        this._importInfo.setTitle(this._treeRoot.getText());
        try {
            if (this._importInfo.getLvl() > 0) {
                WordImport.doImportSplit((InputStream)new ByteArrayInputStream(docBuf), (SplitImportContext)new DefaultSplitImportContext(this.pageManager, rootPage, (Page)this._treeRoot.getOldPage(), this._attachmentManager, this._bookmarks, this._orderedNodes, this._importInfo.getLvl(), this.ocSettingsManager.getMaxImportImageSize()), (boolean)this.ocSettingsManager.isDoFootnotes());
            } else {
                WordImport.doImport((InputStream)new ByteArrayInputStream(docBuf), (ImportContext)new DefaultImportContext(this.pageManager, (AbstractPage)rootPage, (AbstractPage)this._treeRoot.getOldPage(), this._attachmentManager, this._bookmarks, this.ocSettingsManager.getMaxImportImageSize()), (boolean)this.ocSettingsManager.isDoFootnotes());
            }
        }
        catch (ImageSizeException ex) {
            this.addActionError("office.connector.docimport.error.imagesize", new Object[]{ex.getImgSize().width, ex.getImgSize().height, ex.getMaxSize().width, ex.getMaxSize().height});
            return "error";
        }
        this._session.remove(FILE_KEY);
        this._session.remove(NODES_KEY);
        this._session.remove(BOOKMARKS_KEY);
        this._session.remove(TREE_KEY);
        return "success";
    }

    private boolean shouldShowWarning() {
        return this.ocSettingsManager.isShowWarning();
    }

    private boolean permissionChecks(User currentUser) {
        boolean failFast = false;
        if (this._importInfo.isImportSpace()) {
            if (!this.permissionManager.hasCreatePermission(currentUser, (Object)this.getSpace(), Page.class)) {
                this.addActionError("You don't have permission to create pages");
                failFast = true;
            }
        } else {
            AbstractPage currentPage = this.getPage();
            if (!this.permissionManager.hasPermission(currentUser, Permission.EDIT, (Object)this.getPage())) {
                this.addActionError("You don't have permission to edit this page");
                failFast = true;
            }
            if (this._importInfo.getOverwriteAll()) {
                failFast |= this.recursiveDeleteCheck(currentPage, currentUser);
            }
        }
        if (this._importInfo.getConflict() == 2) {
            failFast |= this.conflictDeleteCheck(currentUser);
        }
        return failFast;
    }

    private boolean conflictDeleteCheck(User currentUser) {
        boolean failFast = false;
        if (this._importInfo.isImportSpace()) {
            String text = PageNames.fixPageTitle(this._importInfo.getTitle());
            Page page = this.pageManager.getPage(this.getSpaceKey(), text);
            if (page != null) {
                this._pagesBeingDeleted.add(page.getTitle());
                if (!this.permissionManager.hasPermission(currentUser, Permission.REMOVE, (Object)page)) {
                    this.addActionError("You don't have permission to delete the page \"" + page.getTitle() + "\"");
                    failFast = true;
                }
            }
        }
        for (int x = 0; x < this._orderedNodes.size(); ++x) {
            DocumentTreeNode<Page> node = this._orderedNodes.get(x);
            String text = PageNames.fixPageTitle(node.getText());
            Page page = this.pageManager.getPage(this.getSpaceKey(), text);
            if (page == null || node.getLvl() > this._importInfo.getLvl()) continue;
            this._pagesBeingDeleted.add(page.getTitle());
            if (this.permissionManager.hasPermission(currentUser, Permission.REMOVE, (Object)page)) continue;
            this.addActionError("You don't have permission to delete the page \"" + page.getTitle() + "\"");
            failFast = true;
        }
        return failFast;
    }

    private void recursiveTrash(Page rootPage) {
        List children = rootPage.getChildren();
        for (int x = children.size() - 1; x >= 0; --x) {
            Page childPage = (Page)children.get(x);
            this.recursiveTrash(childPage);
            childPage.trash();
        }
    }

    public String getViewUrl() throws Exception {
        return "/display/" + super.getSpaceKey() + '/' + GeneralUtil.urlEncode((String)this._importInfo.getTitle());
    }

    public String getPageTitle() {
        return this._pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this._pageTitle = pageTitle;
    }

    public List<String> getPagesBeingDeleted() {
        return this._pagesBeingDeleted;
    }

    public boolean getAdvanced() {
        return this._advanced;
    }

    public void setAdvanced(boolean advanced) {
        this._advanced = advanced;
    }

    public DocumentTreeNode<Page> getTreeRoot() {
        return this._treeRoot;
    }

    public boolean isImportSpace() {
        return this._importInfo.isImportSpace();
    }

    public void setImportSpace(boolean space) {
        this._importInfo.setImportSpace(space);
    }

    public int getLvl() {
        return this._importInfo.getLvl();
    }

    public void setLvl(int lvl) {
        this._importInfo.setLvl(lvl);
    }

    public String getDocTitle() {
        return this._importInfo.getTitle();
    }

    public void setDocTitle(String title) {
        this._importInfo.setTitle(title);
    }

    public void setConflict(int conflict) {
        this._importInfo.setConflict(conflict);
    }

    public int getConflict() {
        return this._importInfo.getConflict();
    }

    public void setOverwriteAll(boolean overwrite) {
        this._importInfo.setOverwriteAll(overwrite);
    }

    public boolean getOverwriteAll() {
        return this._importInfo.getOverwriteAll();
    }

    public void setTreeDepth(int depth) {
        this._treeDepth = depth;
    }

    public int getTreeDepth() {
        return this._treeDepth;
    }

    public void setCanaryCage(WordImportCanaryExecutor canaryCage) {
        this.canaryCage = canaryCage;
    }

    public void setAttachmentManager(AttachmentManager manager) {
        this._attachmentManager = manager;
    }

    private byte[] buildDocumentTree(File file, String pageTitle) throws Exception {
        byte[] docBuf = FileUtils.readFileToByteArray((File)file);
        file.delete();
        WordImport.NormalizationResult normalizationResult = WordImport.parseAndNormalize((InputStream)new ByteArrayInputStream(docBuf), (String)pageTitle);
        this._treeRoot = normalizationResult.treeRoot;
        this._orderedNodes = normalizationResult.orderedNodes;
        this._bookmarks = normalizationResult.bookmarks;
        this._treeDepth = normalizationResult.treeDepth;
        return docBuf;
    }

    public void setServletRequest(HttpServletRequest req) {
        this._request = req;
    }

    public void setSession(Map session) {
        this._session = session;
    }

    private void normalizeDocTree(DocumentTreeNode<Page> root) {
        List list = root.getChildren();
        this._treeDepth = Math.max(root.getLvl(), this._treeDepth);
        int lvl = root.getLvl() + 1;
        for (DocumentTreeNode node : list) {
            node.setLvl(lvl);
            this._orderedNodes.add((DocumentTreeNode<Page>)node);
            this.normalizeDocTree((DocumentTreeNode<Page>)node);
        }
    }

    private void resolveTitleConflicts(boolean doDeletes, DocumentTreeNode<Page> treeRoot, List<DocumentTreeNode<Page>> orderedNodes) {
        ImportTitleResolver resolver = new ImportTitleResolver(this._importInfo, this.pageManager, this.getSpaceKey());
        treeRoot.setText(this._importInfo.getTitle());
        resolver.resolveTitle(treeRoot, true);
        for (DocumentTreeNode<Page> orderedNode : orderedNodes) {
            resolver.resolveTitle(orderedNode, false);
        }
        if (doDeletes) {
            resolver.doDeletes();
        }
    }

    public void setOcSettingsManager(OcSettingsManager settingsManager) {
        this.ocSettingsManager = settingsManager;
    }

    private boolean recursiveDeleteCheck(AbstractPage currentPage, User currentUser) {
        boolean failFast = false;
        if (currentPage instanceof Page) {
            List children = ((Page)currentPage).getChildren();
            for (Object child : children) {
                AbstractPage nextChild = (AbstractPage)child;
                this._pagesBeingDeleted.add(nextChild.getTitle());
                if (!this.permissionManager.hasPermission(currentUser, Permission.REMOVE, (Object)nextChild)) {
                    this.addActionError("You don't have permission to delete the page \"" + nextChild.getTitle() + "\"");
                    failFast = true;
                }
                failFast |= this.recursiveDeleteCheck(nextChild, currentUser);
            }
        }
        return failFast;
    }

    public void setImporterSemaphore(ImporterSemaphore importerSemaphore) {
        this.importerSemaphore = importerSemaphore;
    }

    public boolean isPageRequired() {
        return false;
    }

    public void setXsrfTokenService(XsrfTokenService xsrfTokenService) {
        this.xsrfTokenService = xsrfTokenService;
    }
}

