/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.servlet;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.benryan.components.ContentResolver;
import java.io.IOException;
import java.text.ParseException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class DownloadRedirectServlet
extends HttpServlet {
    private static final String TITLE_PARAM = "title";
    private static final String DATE_PARAM = "date";
    private static final String SPACEKEY_PARAM = "space";
    private static final String FILENAME_PARAM = "filename";
    private static final String CONTEXT_ID_PARAM = "contextid";
    private static final String CONTEXT_CONTENT_TYPE_PARAM = "contexttype";
    private ContentResolver contentResolver;
    private PageManager pageManager;
    private DraftManager draftManager;

    public DownloadRedirectServlet(ContentResolver contentResolver, PageManager pageManager, DraftManager draftManager) {
        this.contentResolver = contentResolver;
        this.pageManager = pageManager;
        this.draftManager = draftManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String title = req.getParameter(TITLE_PARAM);
        String dateStr = req.getParameter(DATE_PARAM);
        String spaceKey = req.getParameter(SPACEKEY_PARAM);
        String filename = req.getParameter(FILENAME_PARAM);
        String contextIdStr = req.getParameter(CONTEXT_ID_PARAM);
        String contextType = req.getParameter(CONTEXT_CONTENT_TYPE_PARAM);
        if (StringUtils.isBlank((String)spaceKey) || StringUtils.isBlank((String)contextIdStr) || StringUtils.isBlank((String)filename) || StringUtils.isBlank((String)contextType)) {
            resp.sendError(400, "Request missing required parameters.");
            return;
        }
        long contextId = 0L;
        try {
            contextId = Long.valueOf(contextIdStr);
        }
        catch (NumberFormatException ex) {
            resp.sendError(400, "The contextid must be numeric.");
            return;
        }
        ContentEntityObject context = this.getContextEntity(contextId, contextIdStr, spaceKey, contextType);
        ContentEntityObject ceo = null;
        try {
            ceo = this.contentResolver.getContent(title, spaceKey, dateStr, context);
        }
        catch (ParseException ex) {
            resp.sendError(400, "The date parameter was not of the format mm/dd/yyyy");
            return;
        }
        if (ceo == null) {
            resp.sendError(404, "The requested attachment could not be found.");
        } else {
            resp.sendRedirect(req.getContextPath() + "/download/attachments/" + ceo.getId() + "/" + filename);
        }
    }

    private ContentEntityObject getContextEntity(long contextId, String contextIdStr, String spaceKey, String contentType) {
        if (Draft.NEW.equals(contextIdStr)) {
            return this.draftManager.findDraft(contextIdStr, AuthenticatedUserThreadLocal.getUsername(), contentType, spaceKey);
        }
        return this.pageManager.getById(contextId);
    }
}

