/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.rest;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.benryan.components.OcSettingsManager;
import com.benryan.conversion.WebDavUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Path(value="metadata")
public class EditInOfficeResource {
    private final AttachmentManager attachmentManager;
    private final OcSettingsManager ocSettings;

    public EditInOfficeResource(AttachmentManager attachmentManager, OcSettingsManager ocSettings) {
        this.attachmentManager = attachmentManager;
        this.ocSettings = ocSettings;
    }

    @GET
    @Path(value="/{attachmentId}")
    public Response getEditInOfficeMetadata(@PathParam(value="attachmentId") long attachmentId) {
        HashMap metadata = Maps.newHashMap();
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        WebDavUtil webDavUtil = new WebDavUtil((AbstractPage)attachment.getContent());
        String webDavUrl = webDavUtil.getRelWebDavUrl(attachment.getFileName());
        boolean pathAuth = this.ocSettings.getPathAuth();
        metadata.put("webDavUrl", webDavUrl);
        metadata.put("usePathAuth", pathAuth);
        return Response.ok((Object)metadata).build();
    }
}

