/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.quartz;

import com.benryan.components.DefaultSlideCacheManager;
import com.benryan.components.OcSettingsManager;
import com.benryan.components.SlideCacheManager;
import com.benryan.quartz.CacheCleanupJobDetail;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheCleanup
implements Job {
    private static final Logger log = LoggerFactory.getLogger(CacheCleanup.class);
    private static final Comparator fileDateComparator = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            return new Long(((File)obj1).lastModified()).compareTo(new Long(((File)obj2).lastModified()));
        }
    };

    public void execute(JobExecutionContext context) throws JobExecutionException {
        CacheCleanupJobDetail jobDetail = (CacheCleanupJobDetail)context.getJobDetail();
        OcSettingsManager settingsManager = jobDetail.getSettingsManager();
        SlideCacheManager slideManager = jobDetail.getSlideCacheManager();
        long maxSize = settingsManager.getMaxCacheSize() * 1024 * 1024;
        File tempDir = slideManager.getTempDir();
        this.deleteAllTempFiles(tempDir, slideManager);
        switch (settingsManager.getCacheType()) {
            case 0: 
            case 1: {
                String path = settingsManager.getCacheDir();
                this.cullOldFiles(path, maxSize);
                break;
            }
        }
    }

    private void cullOldFiles(String path, long maxSize) {
        long sum = 0L;
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            int x;
            File[] children = dir.listFiles();
            ArrayList<File> fileList = new ArrayList<File>();
            for (x = 0; x < children.length; ++x) {
                if (!children[x].isFile()) continue;
                sum += children[x].length();
                fileList.add(children[x]);
            }
            if (sum > maxSize) {
                Collections.sort(fileList, fileDateComparator);
                x = 0;
                while (x < fileList.size() && sum > maxSize) {
                    File oldestFile = (File)fileList.get(x++);
                    long oldestSize = oldestFile.length();
                    if (oldestFile.delete()) {
                        sum -= oldestSize;
                        continue;
                    }
                    log.warn("Unable to delete cached conversion " + oldestFile.getAbsolutePath());
                }
                if (sum > maxSize) {
                    log.error("Unable to delete enough files to get cache below max size");
                }
            }
        }
    }

    private void deleteAllTempFiles(File tempDir, SlideCacheManager slideManager) {
        if (tempDir.exists() && tempDir.isDirectory()) {
            Set<DefaultSlideCacheManager.QueueData> beingConvertedKeys = slideManager.getBeingConvertedKeys();
            File[] children = tempDir.listFiles();
            for (int x = 0; x < children.length; ++x) {
                String key = children[x].getName();
                String string = key = key.endsWith(".tmp") ? key.substring(0, key.length() - 4) : key;
                if (beingConvertedKeys.contains(key) || children[x].delete()) continue;
                log.warn("Unable to delete temp file " + children[x].getAbsolutePath());
            }
        }
    }
}

