/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.dom;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugins.conversion.confluence.dom.doc2wiki.splitter.DocumentTreeNode;
import com.benryan.webwork.WordImportInfo;
import com.benryan.webwork.util.PageNames;
import java.util.ArrayList;
import java.util.HashSet;

public class ImportTitleResolver {
    PageManager _pageManager;
    String _spaceKey;
    int _conflictMode;
    int _splitLvl;
    HashSet<String> _internalNames;
    ArrayList<Page> _deleteMe;

    public ImportTitleResolver(WordImportInfo info, PageManager pageManager, String spaceKey) {
        this._pageManager = pageManager;
        this._spaceKey = spaceKey;
        this._conflictMode = info.getConflict();
        this._splitLvl = info.getLvl();
        this._internalNames = new HashSet();
        this._deleteMe = new ArrayList();
    }

    public static String getUniquePageName(String text, HashSet names, PageManager pageManager, String spaceKey) {
        String alternateText = text;
        int i = 0;
        while (names.contains(alternateText) || pageManager.getPage(spaceKey, alternateText) != null) {
            alternateText = text + i++;
        }
        return alternateText;
    }

    public void resolveTitle(DocumentTreeNode<Page> node, boolean isRoot) {
        if (node.getLvl() > this._splitLvl) {
            return;
        }
        String text = PageNames.fixPageTitle(node.getText());
        if (this._internalNames.contains(node.getText())) {
            int i = 0;
            String newTitle = text + i;
            while (this._internalNames.contains(newTitle)) {
                newTitle = text + i;
                ++i;
            }
            text = newTitle;
        }
        node.setText(text);
        Page existingPage = this._pageManager.getPage(this._spaceKey, text);
        if (existingPage != null) {
            if (!isRoot || node.getOldPage() == null) {
                switch (this._conflictMode) {
                    case 2: {
                        this._deleteMe.add(existingPage);
                        break;
                    }
                    case 1: {
                        text = ImportTitleResolver.getUniquePageName(text, this._internalNames, this._pageManager, this._spaceKey);
                        node.setText(text);
                        break;
                    }
                    case 0: {
                        node.setOldPage((Object)existingPage);
                    }
                }
            } else if (existingPage.getId() != ((Page)node.getOldPage()).getId()) {
                text = ImportTitleResolver.getUniquePageName(text, this._internalNames, this._pageManager, this._spaceKey);
                node.setText(text);
            }
        }
        this._internalNames.add(text);
    }

    public void doDeletes() {
        this._deleteMe.forEach(Page::trash);
    }
}

