/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.conversion.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.RenderedContentCleaner;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.macro.ResourceAware;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.thumbnail.Dimensions;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.benryan.components.ContentResolver;
import com.benryan.components.ConverterSemaphore;
import com.benryan.components.HtmlCacheManager;
import com.benryan.components.OcSettingsManager;
import com.benryan.conversion.macro.ConverterMacro;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ViewOfficeFile
implements Macro,
EditorImagePlaceholder,
ResourceAware {
    private static final int HEIGHT = 300;
    private static final int WIDTH = 380;
    private PluginAccessor pluginAccessor;
    private AttachmentManager attachmentManager;
    private SettingsManager settingsManager;
    private HtmlCacheManager htmlManager;
    private OcSettingsManager ocSettingsManager;
    private VelocityHelperService velocityHelperService;
    private WebResourceManager webResourceManager;
    private PermissionManager permissionManager;
    private ContentResolver contentResolver;
    private RenderedContentCleaner renderedContentCleaner;
    private ConverterSemaphore converterSemaphore;
    private String resourcePath;

    public ViewOfficeFile(PluginAccessor pluginAccessor, AttachmentManager attachmentManager, SettingsManager settingsManager, HtmlCacheManager htmlManager, OcSettingsManager ocSettingsManager, VelocityHelperService velocityHelperService, WebResourceManager webResourceManager, PermissionManager permissionManager, ContentResolver contentResolver, RenderedContentCleaner renderedContentCleaner, ConverterSemaphore converterSemaphore) {
        this.pluginAccessor = pluginAccessor;
        this.attachmentManager = attachmentManager;
        this.settingsManager = settingsManager;
        this.htmlManager = htmlManager;
        this.ocSettingsManager = ocSettingsManager;
        this.velocityHelperService = velocityHelperService;
        this.webResourceManager = webResourceManager;
        this.permissionManager = permissionManager;
        this.contentResolver = contentResolver;
        this.renderedContentCleaner = renderedContentCleaner;
        this.converterSemaphore = converterSemaphore;
    }

    public String execute(Map<String, String> params, String body, ConversionContext conversionContext) throws MacroExecutionException {
        ConverterMacro macro = this.createConverterMacro();
        try {
            return macro.execute(params, body, (RenderContext)(conversionContext != null ? conversionContext.getPageContext() : null));
        }
        catch (MacroException ex) {
            throw new MacroExecutionException(ex.getMessage(), ex.getCause());
        }
    }

    private ConverterMacro createConverterMacro() {
        ConverterMacro macro = new ConverterMacro();
        macro.setAttachmentManager(this.attachmentManager);
        macro.setHtmlCacheManager(this.htmlManager);
        macro.setOcSettingsManager(this.ocSettingsManager);
        macro.setPermissionManager(this.permissionManager);
        macro.setPluginAccessor(this.pluginAccessor);
        macro.setSettingsManager(this.settingsManager);
        macro.setVelocityHelperService(this.velocityHelperService);
        macro.setWebResourceManager(this.webResourceManager);
        macro.setContentResolver(this.contentResolver);
        macro.setRenderedContentCleaner(this.renderedContentCleaner);
        macro.setConverterSemaphore(this.converterSemaphore);
        return macro;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> params, ConversionContext conversionContext) {
        String name = params.get("name");
        if (name == null) {
            name = params.get("0");
        }
        if (StringUtils.isBlank((String)name)) {
            return new DefaultImagePlaceholder(this.resourcePath + "/images/generic-editor-placeholder-small.png", new Dimensions(380, 300), true);
        }
        int dotIdx = name.lastIndexOf(46);
        String type = null;
        if (dotIdx != -1) {
            type = name.substring(dotIdx + 1).toLowerCase();
        }
        if (type == null) {
            return new DefaultImagePlaceholder(this.resourcePath + "/images/generic-editor-placeholder-small.png", new Dimensions(380, 300), true);
        }
        if (type.startsWith("doc")) {
            return new DefaultImagePlaceholder(this.resourcePath + "/images/word-editor-placeholder.png", new Dimensions(380, 300), true);
        }
        if (type.startsWith("xls")) {
            return new DefaultImagePlaceholder(this.resourcePath + "/images/excel-editor-placeholder.png", new Dimensions(380, 300), true);
        }
        if (type.startsWith("ppt")) {
            return new DefaultImagePlaceholder(this.resourcePath + "/images/powerpoint-editor-placeholder.png", new Dimensions(380, 300), true);
        }
        if (type.equals("pdf")) {
            return new DefaultImagePlaceholder(this.resourcePath + "/images/pdf-editor-placeholder.png", new Dimensions(380, 300), true);
        }
        return new DefaultImagePlaceholder(this.resourcePath + "/images/generic-editor-placeholder-small.png", new Dimensions(380, 300), true);
    }
}

