/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.conversion.macro;

import com.atlassian.confluence.content.render.xhtml.RenderedContentCleaner;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.benryan.components.AutoCloseableSemaphore;
import com.benryan.components.ContentResolver;
import com.benryan.components.ConverterSemaphore;
import com.benryan.components.HtmlCacheManager;
import com.benryan.components.OcSettingsManager;
import com.benryan.conversion.DocConverter;
import com.benryan.conversion.PptConverter;
import com.benryan.conversion.WebDavUtil;
import com.benryan.conversion.XlsConverter;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterMacro
extends BaseMacro {
    public static final Logger log = LoggerFactory.getLogger(ConverterMacro.class);
    public static final String NAME_KEY = "name";
    public static final String PAGE_KEY = "page";
    public static final String SPACE_KEY = "space";
    public static final String TYPE_KEY = "type";
    public static final String DATE_KEY = "date";
    public static final String INPUT_KEY = "input";
    public static final String FULLNAME_KEY = "fullname";
    public static final String ATTACHMENT_KEY = "attachment";
    public static final String URL_KEY = "url";
    public static final String CONTEXT_KEY = "context";
    public static final String ATTACHMENTOBJ_KEY = "attachmentObj";
    public static final String EDITURL_KEY = "editUrl";
    public static final String BASEURL_KEY = "baseUrl";
    public static final String SERVLET_BASE_URL = "servletBaseUrl";
    public static final String PAGE_ID_KEY = "pageID";
    public static final String ALLOW_EDIT_KEY = "isNews";
    public static final String USE_JAVASCRIPT = "useJavascript";
    public static final String RESOURCE_KEY = "resourcePath";
    public static final String USE_PATHAUTH = "usePathAuth";
    public static final String EDITGRID_FILE_KEY = "filename";
    private static String OC_PLUGIN_KEY = "com.atlassian.confluence.extra.officeconnector:pptslideservlet";
    protected PluginAccessor _pluginAccessor;
    protected AttachmentManager _attachmentManager;
    private SettingsManager _settings;
    private HtmlCacheManager htmlManager;
    private OcSettingsManager ocSettings;
    private VelocityHelperService velocityHelperService;
    private WebResourceManager webResourceManager;
    private PermissionManager permissionManager;
    private ContentResolver contentResolver;
    private RenderedContentCleaner renderedContentCleaner;
    private ConverterSemaphore converterSemaphore;

    public void disabled() {
    }

    public String execute(Map args, String body, RenderContext context) throws MacroException {
        try (AutoCloseableSemaphore semaphore = this.converterSemaphore.acquire();){
            String string = this.doExecute(args, context);
            return string;
        }
    }

    private String doExecute(Map args, RenderContext context) throws MacroException {
        int dotIdx;
        String file = (String)args.get("0");
        if (file == null && (file = (String)args.get(EDITGRID_FILE_KEY)) == null && ((file = (String)args.get(NAME_KEY)) == null || file.trim().length() == 0)) {
            throw new MacroException("No attachment name specified");
        }
        ContentEntityObject page = null;
        String pageName = (String)args.get(PAGE_KEY);
        String space = (String)args.get(SPACE_KEY);
        String typeName = (String)args.get(TYPE_KEY);
        String date = (String)args.get(DATE_KEY);
        if (typeName == null && (dotIdx = file.lastIndexOf(46)) != -1) {
            typeName = file.substring(dotIdx + 1);
            args.put(TYPE_KEY, typeName);
        }
        try {
            page = this.contentResolver.getContent(pageName, space, date, this.getContentObject(context));
        }
        catch (ParseException ex) {
            throw new MacroException("Unrecognized date string, please use mm/dd/yyyy");
        }
        catch (IllegalArgumentException ex) {
            throw new MacroException("The space key could not be found.");
        }
        if (page == null) {
            throw new MacroException("The viewfile macro is unable to locate the page \"" + pageName + "\" in space \"" + space + "\"");
        }
        String baseUrl = this._settings.getGlobalSettings().getBaseUrl();
        Attachment attachment = this._attachmentManager.getAttachment(page, file);
        if (attachment == null) {
            throw new MacroException("The viewfile macro is unable to locate the attachment \"" + file + "\" on " + (pageName == null ? "this page" : "the page \"" + pageName + "\" in space \"" + space + "\""));
        }
        if (log.isDebugEnabled()) {
            ContentEntityObject content;
            String message = "Executing converter macro with attachment: '" + attachment + "' that belongs to page: '" + page + "'. ";
            if (context instanceof PageContext && (content = ((PageContext)context).getEntity()) != null) {
                message = message + "This macro was added to the following piece of content: " + content;
            }
            log.debug(message);
        }
        this.checkPermissions(page, space, attachment);
        HttpServletRequest request = ServletContextThreadLocal.getRequest();
        String contextPath = request != null ? request.getContextPath() : "";
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        argsMap.putAll(args);
        if (page instanceof Page) {
            WebDavUtil util = new WebDavUtil((AbstractPage)page);
            argsMap.put(EDITURL_KEY, util.getRelWebDavUrl(file));
        }
        boolean isPreview = context.getOutputType().equals("preview");
        argsMap.put(ALLOW_EDIT_KEY, page instanceof Page && !isPreview && this.permissionManager.hasPermission(AuthenticatedUserThreadLocal.getUser(), Permission.EDIT, (Object)page));
        argsMap.put(ATTACHMENTOBJ_KEY, attachment);
        argsMap.put(PAGE_ID_KEY, String.valueOf(page.getId()));
        argsMap.put(CONTEXT_KEY, contextPath);
        argsMap.put(ATTACHMENT_KEY, file);
        argsMap.put(BASEURL_KEY, baseUrl);
        argsMap.put(SERVLET_BASE_URL, contextPath);
        argsMap.put(USE_JAVASCRIPT, context == null || !isPreview);
        argsMap.put(RESOURCE_KEY, this.getResourcePath());
        argsMap.put(USE_PATHAUTH, this.ocSettings.getPathAuth());
        if (context.getOutputType().equals("page_gadget")) {
            argsMap.put(SERVLET_BASE_URL, baseUrl);
            argsMap.put(CONTEXT_KEY, baseUrl);
            argsMap.put(RESOURCE_KEY, baseUrl.substring(0, baseUrl.length() - contextPath.length()) + this.getResourcePath());
            argsMap.put(ALLOW_EDIT_KEY, false);
        }
        try {
            if (typeName.equalsIgnoreCase("pdf") || typeName.equalsIgnoreCase("ppt") || typeName.equalsIgnoreCase("pptx")) {
                this.webResourceManager.requireResource("com.atlassian.confluence.extra.officeconnector:slide-viewer-resources");
                PptConverter converter = new PptConverter(this.velocityHelperService);
                return converter.execute(argsMap);
            }
            if (typeName.equalsIgnoreCase("doc") || typeName.equalsIgnoreCase("docx")) {
                DocConverter converter = new DocConverter(this.htmlManager);
                return converter.execute(argsMap);
            }
            if (typeName.equalsIgnoreCase("xls") || typeName.equalsIgnoreCase("xlsx")) {
                XlsConverter converter = new XlsConverter(this.htmlManager, this.renderedContentCleaner);
                return converter.execute(argsMap);
            }
            throw new MacroException("The viewfile macro only supports pdf, doc, xls, and ppt file types");
        }
        catch (MacroException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MacroException((Throwable)e);
        }
    }

    private void checkPermissions(ContentEntityObject page, String space, Attachment attachment) throws MacroException {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)attachment) && !GeneralUtil.isSuperUser((User)user)) {
            throw new MacroException("You don't have sufficient privileges to view the attachment '" + attachment.getFileName() + "' from page '" + page.getTitle() + "' in space '" + space + "'");
        }
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public boolean hasBody() {
        return false;
    }

    public boolean isInline() {
        return false;
    }

    public void setAttachmentManager(AttachmentManager manager) {
        this._attachmentManager = manager;
    }

    public void setPluginAccessor(PluginAccessor accessor) {
        this._pluginAccessor = accessor;
    }

    public void setSettingsManager(SettingsManager settings) {
        this._settings = settings;
    }

    public void setOcSettingsManager(OcSettingsManager ocSettings) {
        this.ocSettings = ocSettings;
    }

    public void setHtmlCacheManager(HtmlCacheManager manager) {
        this.htmlManager = manager;
    }

    public void setWebResourceManager(WebResourceManager manager) {
        this.webResourceManager = manager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setRenderedContentCleaner(RenderedContentCleaner renderedContentCleaner) {
        this.renderedContentCleaner = renderedContentCleaner;
    }

    private ContentEntityObject getContentObject(RenderContext context) throws MacroException {
        if (!(context instanceof PageContext)) {
            return null;
        }
        ContentEntityObject contentObject = ((PageContext)context).getEntity();
        return contentObject;
    }

    private String getResourcePath() {
        String path = this.webResourceManager.getStaticPluginResource(OC_PLUGIN_KEY, "conversion");
        if (path != null && path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public void setVelocityHelperService(VelocityHelperService velocityHelperService) {
        this.velocityHelperService = velocityHelperService;
    }

    public void setContentResolver(ContentResolver contentResolver) {
        this.contentResolver = contentResolver;
    }

    public void setConverterSemaphore(ConverterSemaphore converterSemaphore) {
        this.converterSemaphore = converterSemaphore;
    }
}

