/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.conversion;

import com.atlassian.confluence.content.render.xhtml.RenderedContentCleaner;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.plugins.conversion.convert.ConversionException;
import com.atlassian.plugins.conversion.convert.html.HtmlConversionResult;
import com.atlassian.plugins.conversion.convert.html.spreadsheet.SpreadsheetConverter;
import com.benryan.components.HtmlCacheManager;
import com.benryan.conversion.DocConverter;
import java.io.InputStream;
import java.util.Map;

public class XlsConverter
extends DocConverter {
    private static final String OFFICECONNECTOR_SPREADSHEET_XLSXMAXSIZE = "officeconnector.spreadsheet.xlsxmaxsize";
    private final RenderedContentCleaner renderedContentCleaner;

    public XlsConverter(HtmlCacheManager manager, RenderedContentCleaner renderedContentCleaner) {
        super(manager);
        this.renderedContentCleaner = renderedContentCleaner;
    }

    @Override
    protected HtmlConversionResult doConversion(String imgPath, Map<String, Object> args, InputStream inputStream, String imagePath) throws ConversionException {
        return SpreadsheetConverter.convertToHtml((InputStream)inputStream, (String)imgPath, args, (RenderedContentCleaner)this.renderedContentCleaner);
    }

    @Override
    protected void validate(Attachment attachment, Map<String, Object> args) throws ConversionException {
        long maxBytesXlsx = Long.getLong(OFFICECONNECTOR_SPREADSHEET_XLSXMAXSIZE, 0x200000L);
        Object type = args.get("type");
        if (type != null && type.equals("xlsx") && attachment.getFileSize() > maxBytesXlsx) {
            throw new ConversionException(String.format("Cannot convert %s, this file exceeds the maximum file size for xlsx files of %dMB.", attachment.getFileName(), maxBytesXlsx >> 20));
        }
    }
}

