/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.conversion;

import com.benryan.conversion.SlideDocConversionData;
import com.benryan.conversion.SlidePageConversionData;
import com.benryan.ppt.SlideImageSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SlideConversionDataSerializer
implements SlideImageSerializer,
Iterable<SlidePageConversionData> {
    private final SlideDocConversionData data;
    private final List<SlidePageConversionData> pages = new ArrayList<SlidePageConversionData>();

    public SlideConversionDataSerializer(SlideDocConversionData data) {
        this.data = data;
    }

    public synchronized void serializeSlideImage(byte[] pageData, int slideNum) throws IOException {
        SlidePageConversionData page = new SlidePageConversionData(pageData, slideNum, this.data);
        if (slideNum < this.pages.size()) {
            this.pages.set(slideNum, page);
        } else {
            this.pages.add(slideNum, page);
        }
    }

    public synchronized SlidePageConversionData getPage(int slideNum) {
        if (slideNum >= 0 && slideNum < this.pages.size()) {
            return this.pages.get(slideNum);
        }
        return null;
    }

    @Override
    public Iterator<SlidePageConversionData> iterator() {
        return new ArrayList<SlidePageConversionData>(this.pages).iterator();
    }
}

