/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.conversion;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.renderer.v2.macro.MacroException;
import com.benryan.conversion.macro.ConverterMacro;
import java.util.HashMap;
import java.util.Map;

public class PptConverter {
    public static String WIDTH_KEY = "width";
    public static String HEIGHT_KEY = "height";
    public static String SLIDE_KEY = "slide";
    public static final String DEFAULT_HEIGHT = "507";
    public static final String DEFAULT_WIDTH = "632";
    private VelocityHelperService velocityHelperService;

    public PptConverter(VelocityHelperService velocityHelperService) {
        this.velocityHelperService = velocityHelperService;
    }

    private String normalize(String attr) {
        if (!attr.endsWith("px") && !attr.endsWith("%")) {
            attr = attr + "px";
        }
        return GeneralUtil.htmlEncode((String)attr);
    }

    public String execute(Map args) throws MacroException {
        String pageId = (String)args.get("pageID");
        String attachment = (String)args.get("attachment");
        String editUrl = (String)args.get("editUrl");
        String contextPath = (String)args.get("context");
        String baseUrl = (String)args.get("baseUrl");
        String servletBaseUrl = (String)args.get("servletBaseUrl");
        Boolean allowEdit = (Boolean)args.get("isNews");
        Boolean useJavascript = (Boolean)args.get("useJavascript");
        Boolean usePathAuth = (Boolean)args.get("usePathAuth");
        String width = (String)args.get(WIDTH_KEY);
        String height = (String)args.get(HEIGHT_KEY);
        String slideNum = (String)args.get(SLIDE_KEY);
        Attachment obj = (Attachment)args.get("attachmentObj");
        if (slideNum == null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("allowEdit", allowEdit);
            context.put("resourcePath", (String)args.get("resourcePath"));
            context.put("pageId", GeneralUtil.urlEncode((String)pageId));
            context.put("attachment", GeneralUtil.urlEncode((String)attachment));
            context.put("attachmentId", new Long(obj.getId()));
            context.put("attachmentVer", obj.getAttachmentVersion());
            context.put("downloadPath", obj.getDownloadPathWithoutVersion());
            context.put("width", this.normalize(width == null ? DEFAULT_WIDTH : width));
            context.put("height", this.normalize(height == null ? DEFAULT_HEIGHT : height));
            context.put("editUrl", GeneralUtil.urlEncode((String)editUrl));
            context.put("contextPath", GeneralUtil.urlEncode((String)contextPath));
            context.put("baseUrl", GeneralUtil.urlEncode((String)baseUrl));
            context.put("useJavascript", useJavascript);
            context.put("usePathAuth", usePathAuth);
            String retVal = "";
            try {
                retVal = this.velocityHelperService.getRenderedTemplate("templates/extra/slideviewer/slideviewer.vm", context);
            }
            catch (Exception e) {
                ConverterMacro.log.error("Problem processing template for Flash Slide viewer", (Throwable)e);
                throw new MacroException((Throwable)e);
            }
            return retVal;
        }
        width = width == null ? DEFAULT_WIDTH : GeneralUtil.urlEncode((String)width);
        height = height == null ? DEFAULT_HEIGHT : GeneralUtil.urlEncode((String)height);
        return "<img width=\"" + width + "\" height=\"" + height + "\" src=\"" + servletBaseUrl + "/plugins/servlet/pptslideservlet?slide=" + GeneralUtil.htmlEncode((String)slideNum) + "&pageId=" + GeneralUtil.urlEncode((String)pageId) + "&attachment=" + GeneralUtil.urlEncode((String)attachment) + "&attachmentId=" + obj.getId() + "\" />";
    }
}

