/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.conversion;

import com.atlassian.confluence.pages.Attachment;
import com.benryan.conversion.AbstractSlideConversionTask;
import com.benryan.conversion.MemoryAwarePDFRenderer;
import com.benryan.conversion.SlideDocConversionData;
import com.benryan.conversion.SlidePageConversionData;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class PdfSlideConversionBatchTask
extends AbstractSlideConversionTask<Collection<SlidePageConversionData>> {
    private static final Logger log = LoggerFactory.getLogger(PdfSlideConversionBatchTask.class);
    private final Collection<Integer> pageNumbers;
    private final SlideDocConversionData conversionData;
    private final int MAX_WIDTH = 2496;
    private final int MAX_HEIGHT = 1560;
    private final int ZOOM_LEVEL = 3;

    public PdfSlideConversionBatchTask(Attachment attachment, String attachmentName, Resource resource, SlideDocConversionData conversionData, Collection<Integer> pageNumbersToBeRendered) throws IOException {
        super(attachment, attachmentName, resource);
        this.pageNumbers = pageNumbersToBeRendered;
        this.conversionData = conversionData;
        if (!this.getAttachmentName().endsWith(".pdf")) {
            throw new IllegalArgumentException("Invalid file type for conversion, only PDF suppported : " + this.getAttachmentName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PDFFile getInputPdfFile(Resource inputResource) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(inputResource.getFile());){
            PDFFile pDFFile;
            FileChannel fileChannel = fileInputStream.getChannel();
            try {
                MappedByteBuffer byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, fileChannel.position(), fileChannel.size());
                pDFFile = new PDFFile((ByteBuffer)byteBuffer);
            }
            catch (Throwable throwable) {
                fileChannel.close();
                throw throwable;
            }
            fileChannel.close();
            return pDFFile;
        }
    }

    @Override
    protected Collection<SlidePageConversionData> convertFile() throws IOException {
        log.debug("Rendering {} pages for {}", (Object)this.pageNumbers.size(), (Object)this.getAttachmentDescription());
        long startTime = System.currentTimeMillis();
        PDFFile pdfFile = PdfSlideConversionBatchTask.getInputPdfFile(this.getInputResource());
        int totalPageCountInInputPdf = pdfFile.getNumPages();
        boolean synchronous = true;
        int startPageNumberOffset = pdfFile.getPage(totalPageCountInInputPdf, true) != null ? 1 : 0;
        this.conversionData.setNumSlides(totalPageCountInInputPdf);
        ArrayList<SlidePageConversionData> renderedPages = new ArrayList<SlidePageConversionData>();
        for (int requestedPageNumber : this.pageNumbers) {
            int pageNumberWithinPdfFile = requestedPageNumber + startPageNumberOffset;
            PDFPage pdfPage = pdfFile.getPage(pageNumberWithinPdfFile, true);
            if (pdfPage == null) continue;
            renderedPages.add(this.convertPdfPage(pdfPage, requestedPageNumber));
            pdfFile.flushPage(pageNumberWithinPdfFile);
        }
        log.debug("Completed rendering {} pages for {} in {} ms", new Object[]{this.pageNumbers.size(), this.getAttachmentDescription(), System.currentTimeMillis() - startTime});
        return renderedPages;
    }

    private SlidePageConversionData convertPdfPage(PDFPage pdfPage, int pageNumber) throws IOException {
        log.trace("Rendering page number {} for {}", (Object)pdfPage.getPageNumber(), (Object)this.getAttachmentDescription());
        long startTime = System.currentTimeMillis();
        Rectangle documentDimensions = PdfSlideConversionBatchTask.limitTo(new Rectangle(0, 0, (int)(pdfPage.getBBox().getWidth() * 3.0), (int)(pdfPage.getBBox().getHeight() * 3.0)), 2496, 1560);
        BufferedImage bufferedImage = new BufferedImage(documentDimensions.width, documentDimensions.height, 1);
        Graphics2D graphics2d = bufferedImage.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        MemoryAwarePDFRenderer renderer = new MemoryAwarePDFRenderer(pdfPage, graphics2d, documentDimensions, null, Color.WHITE);
        renderer.run();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "jpg", out);
        log.trace("Completed rendering page number {} for {} in {} ms", new Object[]{pdfPage.getPageNumber(), this.getAttachmentDescription(), System.currentTimeMillis() - startTime});
        return new SlidePageConversionData(out.toByteArray(), pageNumber, this.conversionData);
    }

    static Rectangle limitTo(Rectangle bounds, int maxWidth, int maxHeight) {
        float widthRatio = (float)maxWidth / (float)bounds.width;
        float heightRatio = (float)maxHeight / (float)bounds.height;
        if (widthRatio < 1.0f && widthRatio < heightRatio) {
            return new Rectangle(bounds.x, bounds.y, maxWidth, (int)((float)bounds.height * widthRatio));
        }
        if (heightRatio < 1.0f) {
            return new Rectangle(bounds.x, bounds.y, (int)((float)bounds.width * heightRatio), maxHeight);
        }
        return bounds;
    }
}

