/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.conversion;

import com.atlassian.confluence.pages.Attachment;
import com.benryan.conversion.AbstractSlideConversionTask;
import com.benryan.conversion.SlideConversionDataSerializer;
import com.benryan.conversion.SlideDocConversionData;
import com.benryan.ppt.ImagePPTRenderer;
import com.benryan.ppt.PptRenderer;
import com.benryan.ppt.SlideImageSerializer;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class PPtDocumentConversionTask
extends AbstractSlideConversionTask<SlideConversionDataSerializer> {
    private static final Logger log = LoggerFactory.getLogger(PPtDocumentConversionTask.class);
    private final SlideDocConversionData data;

    public PPtDocumentConversionTask(Attachment attachment, String attachmentName, Resource resource, SlideDocConversionData data) {
        super(attachment, attachmentName, resource);
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SlideConversionDataSerializer convertFile() throws IOException {
        log.debug("Rendering pages for {}", (Object)this.getAttachmentDescription());
        long startTime = System.currentTimeMillis();
        InputStream in = this.getInputResource().getInputStream();
        PptRenderer renderer = null;
        try {
            renderer = this.createPptRenderer(in);
            this.data.setNumSlides(renderer.getNumSlides());
            SlideConversionDataSerializer serializer = new SlideConversionDataSerializer(this.data);
            renderer.setSerializer((SlideImageSerializer)serializer);
            renderer.render(0, 0, PPtDocumentConversionTask.getRenderHints());
            log.debug("Completed rendering pages for {} in {} ms", new Object[]{this.getAttachmentDescription(), System.currentTimeMillis() - startTime});
            SlideConversionDataSerializer slideConversionDataSerializer = serializer;
            return slideConversionDataSerializer;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            if (renderer != null) {
                renderer.close();
            }
        }
    }

    private static Map<RenderingHints.Key, Object> getRenderHints() {
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        return hints;
    }

    private PptRenderer createPptRenderer(InputStream in) throws IOException {
        if (this.getAttachmentName().endsWith(".ppt")) {
            return new ImagePPTRenderer(in);
        }
        if (this.getAttachmentName().endsWith(".pptx")) {
            return new ImagePPTRenderer(in, true);
        }
        throw new IllegalArgumentException("Cannot convert slide, can only handle .ppt or .pptx, but instead got :" + this.getAttachmentName());
    }
}

