/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.conversion;

import com.atlassian.util.concurrent.ConcurrentOperationMap;
import com.atlassian.util.concurrent.ConcurrentOperationMapImpl;
import com.benryan.conversion.ConversionCache;
import com.google.common.base.Throwables;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBackedCache
implements ConversionCache {
    private static Logger log = LoggerFactory.getLogger(FileBackedCache.class);
    private final ConcurrentOperationMap<String, Object> operationMap = new ConcurrentOperationMapImpl();
    private final File _cacheDir;

    public FileBackedCache(String path) throws IOException {
        this._cacheDir = new File(path);
        if (!this._cacheDir.exists() && !this._cacheDir.mkdirs()) {
            throw new IOException("The specified path: " + path + " doesn't exist and we are unable to create it.");
        }
        if (!this._cacheDir.canRead() || !this._cacheDir.canWrite()) {
            throw new IOException("Confluence doesn't have read/write access to the specified cache directory:" + path + ".");
        }
    }

    @Override
    public Object get(Object key) {
        String name = key.toString();
        try {
            return this.operationMap.runOperation((Object)name, () -> this.loadFile(name));
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadFile(String name) {
        Object inObj = null;
        File child = new File(this._cacheDir, name);
        if (child.exists() && child.canRead()) {
            FileInputStream fileIn = null;
            BufferedInputStream bufferIn = null;
            ObjectInputStream in = null;
            try {
                fileIn = new FileInputStream(child);
                bufferIn = new BufferedInputStream(fileIn);
                in = new ObjectInputStream(bufferIn);
                inObj = in.readObject();
            }
            catch (Exception e) {
                try {
                    log.warn("Failed to read file " + child + ": " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(bufferIn);
                    IOUtils.closeQuietly((InputStream)fileIn);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((InputStream)bufferIn);
                IOUtils.closeQuietly((InputStream)fileIn);
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((InputStream)bufferIn);
            IOUtils.closeQuietly((InputStream)fileIn);
        }
        return inObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object key, Object val) {
        block4: {
            String name = key.toString();
            if (!(val instanceof Serializable)) break block4;
            File file = new File(this._cacheDir, name);
            File tmpFile = new File(this._cacheDir, name + ".part");
            FileOutputStream fileOut = null;
            BufferedOutputStream bufferOut = null;
            ObjectOutputStream out = null;
            try {
                fileOut = new FileOutputStream(tmpFile);
                bufferOut = new BufferedOutputStream(fileOut);
                out = new ObjectOutputStream(bufferOut);
                out.writeObject(val);
            }
            catch (Exception e) {
                try {
                    log.warn("Failed to write file " + file + ": " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    IOUtils.closeQuietly(bufferOut);
                    IOUtils.closeQuietly((OutputStream)fileOut);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly((OutputStream)bufferOut);
                IOUtils.closeQuietly((OutputStream)fileOut);
            }
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly((OutputStream)bufferOut);
            IOUtils.closeQuietly((OutputStream)fileOut);
            tmpFile.renameTo(file);
        }
    }
}

