/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.conversion;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.velocity.htmlsafe.HtmlFragment;
import com.atlassian.plugins.conversion.convert.ConversionException;
import com.atlassian.plugins.conversion.convert.html.HtmlConversionResult;
import com.atlassian.plugins.conversion.convert.html.word.WordConverter;
import com.benryan.components.AttachmentCacheKey;
import com.benryan.components.HtmlCacheManager;
import com.benryan.conversion.Converter;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class DocConverter
extends Converter {
    private HtmlCacheManager htmlCacheManager;

    public DocConverter(HtmlCacheManager htmlCacheManager) {
        this.htmlCacheManager = htmlCacheManager;
    }

    @Override
    public String execute(Map<String, Object> args) throws Exception {
        AttachmentCacheKey dataKey;
        HtmlConversionResult data;
        String pageId = (String)args.get("pageID");
        String attachment = (String)args.get("attachment");
        String editUrl = (String)args.get("editUrl");
        String contextPath = (String)args.get("context");
        Boolean allowEdit = (Boolean)args.get("isNews");
        Boolean usePathAuth = (Boolean)args.get("usePathAuth");
        String sheetName = (String)args.get("sheet");
        Attachment attachmentObj = (Attachment)args.get("attachmentObj");
        this.validate(attachmentObj, args);
        if (attachmentObj == null) {
            return null;
        }
        String attachmentId = String.valueOf(attachmentObj.getId());
        if (contextPath == null) {
            contextPath = "";
        }
        String path = contextPath + "/plugins/servlet/benryanconversion" + "?pageId=" + pageId + "&attachment=" + GeneralUtil.urlEncode((String)attachment) + "&name=" + attachmentId;
        if (sheetName != null) {
            path = path + "&sheetName=" + GeneralUtil.urlEncode((String)sheetName);
        }
        if ((data = this.htmlCacheManager.getHtmlConversionData(dataKey = new AttachmentCacheKey(attachmentObj, sheetName))) == null) {
            data = this.doConversion(path, args, attachmentObj.getContentsAsStream(), path + "&val=");
            this.htmlCacheManager.addHtmlConversionData(dataKey, data);
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("allowEdit", allowEdit);
        context.put("contentHtml", new HtmlFragment((Object)data.getHtml()));
        context.put("resourcePath", args.get("resourcePath"));
        context.put("title", attachment);
        context.put("editHrefHtml", GeneralUtil.htmlEncode((String)(contextPath + GeneralUtil.escapeForJavascript((String)editUrl))));
        context.put("usePathAuth", usePathAuth);
        return this.getRenderedTemplate(context);
    }

    protected void validate(Attachment attachment, Map<String, Object> args) throws ConversionException {
    }

    protected String getRenderedTemplate(Map<String, Object> context) {
        return VelocityUtils.getRenderedTemplate((String)"templates/extra/conversion/conversion.vm", context);
    }

    protected HtmlConversionResult doConversion(String imgPath, Map<String, Object> args, InputStream inputStream, String imagePath) throws ConversionException {
        return WordConverter.convertToHtml((InputStream)inputStream, (String)imagePath);
    }
}

