/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.components;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.util.concurrent.Lazy;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.VCacheUtils;
import com.atlassian.vcache.marshallers.MarshallerFactory;
import com.benryan.components.TemporaryAuthTokenManager;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="temporaryAuthTokenManager")
public class DefaultTemporaryAuthTokenManager
implements TemporaryAuthTokenManager {
    private static final Duration EXPIRY_TIME = Duration.ofMinutes(10L);
    private static final String CACHE_NAME = DefaultTemporaryAuthTokenManager.class.getName() + ".temporary.tokens";
    private final UserAccessor userAccessor;
    private final Supplier<DirectExternalCache<String>> tokenCacheRef = Lazy.supplier(() -> cacheFactory.getDirectExternalCache(CACHE_NAME, MarshallerFactory.serializableMarshaller(String.class), new ExternalCacheSettingsBuilder().defaultTtl(EXPIRY_TIME).build()));

    @Autowired
    public DefaultTemporaryAuthTokenManager(VCacheFactory cacheFactory, UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public String createToken(User user) {
        UUID randomUUID = UUID.randomUUID();
        String token = randomUUID.toString();
        VCacheUtils.join((CompletionStage)((DirectExternalCache)this.tokenCacheRef.get()).put(token, (Object)user.getName(), PutPolicy.PUT_ALWAYS));
        return token;
    }

    @Override
    public ConfluenceUser getUser(String token) throws EntityException {
        return ((Optional)VCacheUtils.join((CompletionStage)((DirectExternalCache)this.tokenCacheRef.get()).get(token))).map(arg_0 -> ((UserAccessor)this.userAccessor).getUserByName(arg_0)).orElse(null);
    }

    @Override
    @Deprecated
    public void cleanExpiredTokens() {
    }
}

