/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.components;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.util.concurrent.ThreadFactories;
import com.benryan.components.AbstractConversionCacheManager;
import com.benryan.components.ConvertedPageResult;
import com.benryan.components.SlideCacheManager;
import com.benryan.conversion.PPtDocumentConversionTask;
import com.benryan.conversion.PdfSlideConversionBatchTask;
import com.benryan.conversion.SlideConversionDataSerializer;
import com.benryan.conversion.SlideDocConversionData;
import com.benryan.conversion.SlidePageConversionData;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component(value="slideCacheManager")
public class DefaultSlideCacheManager
extends AbstractConversionCacheManager<QueueData, SlidePageConversionData>
implements SlideCacheManager {
    private static final int KEEP_ALIVE = 120;
    private final int CONVERSION_BATCH_SIZE = Integer.getInteger("officeconnector.slide.conversion.batchsize", 4);
    private ThreadPoolExecutor conversionQueue;
    private File tempDir;
    @GuardedBy(value="self")
    private final BiMap<QueueData, ConvertedPageResult<?>> beingConverted = Maps.synchronizedBiMap((BiMap)HashBiMap.create(new LinkedHashMap()));

    @Override
    public Future<SlidePageConversionData> getSlideConversionData(Attachment attachment, int slideNum) throws IOException {
        ListenableFuture<SlidePageConversionData> future = this.getFuture(attachment, slideNum);
        if (slideNum == 0 || slideNum == 1) {
            return future;
        }
        this.preEmptivePageLoad(future, attachment, slideNum);
        return future;
    }

    private void preEmptivePageLoad(final ListenableFuture<SlidePageConversionData> currentBatch, final Attachment attachment, final int slideNum) throws IOException {
        if (slideNum % this.CONVERSION_BATCH_SIZE > 0) {
            currentBatch.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        int premptivePageLoad = (slideNum / DefaultSlideCacheManager.this.CONVERSION_BATCH_SIZE + 1) * DefaultSlideCacheManager.this.CONVERSION_BATCH_SIZE;
                        int numSlides = ((SlidePageConversionData)currentBatch.get()).getParent().getNumSlides();
                        if (premptivePageLoad < numSlides) {
                            DefaultSlideCacheManager.this.getFuture(attachment, premptivePageLoad, numSlides);
                        }
                    }
                    catch (Exception e) {
                        AbstractConversionCacheManager.log.warn("Failed queue up the next batch: " + e.getMessage(), (Throwable)e);
                    }
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
        }
    }

    private ListenableFuture<SlidePageConversionData> getFuture(Attachment attachment, int slideNum) throws IOException {
        return this.getFuture(attachment, slideNum, Integer.MAX_VALUE);
    }

    private ListenableFuture<SlidePageConversionData> getFuture(Attachment attachment, int slideNum, int numSlides) throws IOException {
        QueueData key = this.getKey(new SlideDocConversionData(attachment), slideNum);
        ListenableFuture futureTask = (ListenableFuture)this.beingConverted.get((Object)key);
        if (futureTask != null) {
            return futureTask;
        }
        SlidePageConversionData data = (SlidePageConversionData)this.getFromCache(key);
        if (data == null || data.getParent().getQueueDate() == null) {
            return this.queueNewConversion(attachment, slideNum, numSlides);
        }
        Date queueDate = data.getParent().getQueueDate();
        if (queueDate.before(attachment.getLastModificationDate()) || queueDate.before(this.lastUpgrade)) {
            return this.queueNewConversion(attachment, slideNum, numSlides);
        }
        SettableFuture settableFuture = SettableFuture.create();
        settableFuture.set((Object)data);
        return settableFuture;
    }

    private void finish(ConvertedPageResult<?> task) {
        try {
            SlidePageConversionData page;
            if (!task.isDone()) {
                throw new IllegalArgumentException("Should only finish tasks that are done :" + task);
            }
            if (!task.isCancelled() && (page = task.get()) != null) {
                this.putToCache(this.getKey(page), page);
            }
        }
        catch (ExecutionException ee) {
            log.error("Error converting page, could not create slide", (Throwable)ee);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.beingConverted.inverse().remove(task);
        }
    }

    private QueueData getKey(SlidePageConversionData page) {
        return new QueueData(page.getParent(), page.getSlideNum());
    }

    private QueueData getKey(long id, int pageNum) {
        return new QueueData(new SlideDocConversionData(id, "", ""), pageNum);
    }

    private QueueData getKey(SlideDocConversionData id, int pageNum) {
        return new QueueData(id, pageNum);
    }

    @Override
    public void initCache() {
        super.initCache();
        int poolSize = this.ocSettingsManager.getMaxQueues();
        if (this.conversionQueue == null) {
            this.conversionQueue = new ThreadPoolExecutor(poolSize, poolSize, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue(), ThreadFactories.namedThreadFactory((String)this.getClass().getSimpleName())){

                @Override
                protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
                    return ListenableFutureTask.create(callable);
                }
            };
        } else {
            this.conversionQueue.setCorePoolSize(poolSize);
            this.conversionQueue.setMaximumPoolSize(poolSize);
        }
        this.tempDir = new File(this.ocSettingsManager.getCacheDir() + File.separator + "temp");
        if (this.tempDir.exists()) {
            File[] files = this.tempDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.delete()) continue;
                    log.error("Can't delete DefaultSlideCacheManager cache file: " + file.getAbsolutePath());
                }
            }
        } else if (!this.tempDir.mkdirs()) {
            log.error("Can't create temp directory for conversion queue: dir=" + this.tempDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromQueue(long attachmentId) {
        BiMap<QueueData, ConvertedPageResult<?>> biMap = this.beingConverted;
        synchronized (biMap) {
            for (QueueData queueData : new HashSet(this.beingConverted.keySet())) {
                Future data;
                if (queueData.getConversionData().getKey() != attachmentId || (data = (Future)this.beingConverted.get((Object)queueData)) == null || !data.isDone() && !data.cancel(true)) continue;
                this.beingConverted.remove((Object)data);
            }
        }
    }

    private synchronized ListenableFuture<SlidePageConversionData> queueNewConversion(Attachment file, int slideNum, int numSlides) throws IOException {
        SlideDocConversionData data = new SlideDocConversionData(file.getId(), file.getContent().getTitle(), file.getFileName());
        String attachmentName = file.getFileName();
        String lowerCaseName = attachmentName.toLowerCase();
        if (lowerCaseName.endsWith(".ppt") || lowerCaseName.endsWith(".pptx")) {
            ConvertedPageResult pptConversionResult = (ConvertedPageResult)((Object)this.beingConverted.get((Object)this.getKey(data, -1)));
            if (pptConversionResult != null) {
                return ConvertedPageResult.copyPptConversionResult(pptConversionResult, slideNum);
            }
            return this.queueNewPptConversion(file, attachmentName, data, slideNum);
        }
        if (lowerCaseName.endsWith(".pdf")) {
            ListenableFuture futureTask = (ListenableFuture)this.beingConverted.get((Object)new QueueData(data, slideNum));
            if (futureTask != null) {
                return futureTask;
            }
            return this.queueNewPdfConversion(file, attachmentName, data, slideNum, numSlides);
        }
        throw new IllegalArgumentException("Cannot create conversion task for file extension, supported types are .pdf, .ppt and .pptx, but got : " + attachmentName);
    }

    private ListenableFuture<SlidePageConversionData> queueNewPptConversion(Attachment file, String attachmentName, SlideDocConversionData data, int slideNum) throws IOException {
        final Resource fileSource = this.transferDataToTempFile(file);
        PPtDocumentConversionTask task = new PPtDocumentConversionTask(file, attachmentName, fileSource, data);
        final ListenableFuture future = (ListenableFuture)this.conversionQueue.submit(task);
        future.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    fileSource.getFile().delete();
                    SlideConversionDataSerializer serializer = (SlideConversionDataSerializer)future.get();
                    if (serializer != null) {
                        DefaultSlideCacheManager.this.cachePptSlides(serializer);
                    }
                }
                catch (Exception ex) {
                    AbstractConversionCacheManager.log.error("Could not convert powerpoint", (Throwable)ex);
                }
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        SlideDocConversionData conversionData = new SlideDocConversionData(file.getId(), file.getContent().getTitle(), file.getFileName());
        this.addToBeingConverted(this.getKey(conversionData, -1), ConvertedPageResult.createPptConversionResult((ListenableFuture<SlideConversionDataSerializer>)future, -1));
        return ConvertedPageResult.createPptConversionResult((ListenableFuture<SlideConversionDataSerializer>)future, slideNum);
    }

    private void cachePptSlides(SlideConversionDataSerializer serializer) {
        for (SlidePageConversionData page : serializer) {
            this.putToCache(this.getKey(page), page);
        }
    }

    private ListenableFuture<SlidePageConversionData> queueNewPdfConversion(Attachment file, String attachmentName, SlideDocConversionData data, int slideNum, int numSlides) throws IOException {
        ConvertedPageResult<?> result = null;
        final Resource fileSource = this.transferDataToTempFile(file);
        ArrayList<Integer> pages = new ArrayList<Integer>(this.CONVERSION_BATCH_SIZE);
        int minSlideNum = slideNum - slideNum % this.CONVERSION_BATCH_SIZE;
        int maxSlideNum = Math.min(minSlideNum + this.CONVERSION_BATCH_SIZE, numSlides);
        for (int i = minSlideNum; i < maxSlideNum; ++i) {
            pages.add(i);
        }
        if (pages.isEmpty()) {
            throw new IllegalArgumentException("Slid conversion pages is required for this type of conversion task");
        }
        PdfSlideConversionBatchTask batchTask = new PdfSlideConversionBatchTask(file, attachmentName, fileSource, data, pages);
        ListenableFuture f = (ListenableFuture)this.conversionQueue.submit(batchTask);
        f.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    fileSource.getFile().delete();
                }
                catch (IOException e) {
                    AbstractConversionCacheManager.log.warn("Could not delete temporary file: " + e.getMessage(), (Throwable)e);
                }
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
        for (Integer pageNum : pages) {
            ConvertedPageResult<?> potentialResult = ConvertedPageResult.createPdfConversionResult((ListenableFuture<Collection<SlidePageConversionData>>)f, pageNum);
            this.addToBeingConverted(this.getKey(data, (int)pageNum), potentialResult);
            if (!pageNum.equals(slideNum)) continue;
            result = potentialResult;
        }
        return result;
    }

    private void addToBeingConverted(QueueData key, final ConvertedPageResult<?> conversionResult) {
        this.beingConverted.put((Object)key, conversionResult);
        conversionResult.addListener(new Runnable(){

            @Override
            public void run() {
                DefaultSlideCacheManager.this.finish(conversionResult);
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
    }

    /*
     * Exception decompiling
     */
    private synchronized Resource transferDataToTempFile(Attachment file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Future<SlidePageConversionData>> getBeingConverted() {
        return new ArrayList<Future<SlidePageConversionData>>(this.beingConverted.values());
    }

    @Override
    public File getTempDir() {
        return this.tempDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueueData> getBeingConvertedKeys() {
        BiMap<QueueData, ConvertedPageResult<?>> biMap = this.beingConverted;
        synchronized (biMap) {
            return new HashSet<QueueData>(this.beingConverted.keySet());
        }
    }

    public static class QueueData {
        private final SlideDocConversionData conversionData;
        private final int slideNum;

        public QueueData(SlideDocConversionData conversionData, int slideNum) {
            this.slideNum = slideNum;
            this.conversionData = conversionData;
        }

        public SlideDocConversionData getConversionData() {
            return this.conversionData;
        }

        public int getSlideNum() {
            return this.slideNum;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)this.conversionData.getKey();
            result = 31 * result + this.slideNum;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueData other = (QueueData)obj;
            if (this.conversionData.getKey() != other.conversionData.getKey()) {
                return false;
            }
            return this.slideNum == other.slideNum;
        }

        public String toString() {
            return "slide-" + this.conversionData.getKey() + '-' + this.slideNum;
        }
    }
}

