/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.components;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.benryan.components.ContentResolver;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="contentResolver")
public class DefaultContentResolver
implements ContentResolver {
    private final PageManager pageManager;

    @Autowired
    public DefaultContentResolver(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    @Override
    public ContentEntityObject getContent(String page, String spaceKey, String date, ContentEntityObject context) throws ParseException {
        if (StringUtils.isBlank((String)page)) {
            return context;
        }
        if (StringUtils.isBlank((String)spaceKey)) {
            spaceKey = this.getSpaceKey(context);
        }
        if (StringUtils.isBlank((String)spaceKey)) {
            throw new IllegalArgumentException("No spaceKey parameter was supplied and it could not be deduced from the context parameter.");
        }
        Page content = null;
        if (StringUtils.isNotBlank((String)date)) {
            DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.US);
            Date parsedDate = dateFormat.parse(date);
            Calendar cal = Calendar.getInstance();
            cal.setTime(parsedDate);
            content = this.pageManager.getBlogPost(spaceKey, page, cal);
        } else {
            content = this.pageManager.getPage(spaceKey, page);
        }
        return content;
    }

    private String getSpaceKey(ContentEntityObject contentObject) {
        if (contentObject == null) {
            return null;
        }
        String spaceKey = null;
        if (contentObject instanceof Comment) {
            contentObject = ((Comment)contentObject).getOwner();
        }
        if (contentObject instanceof SpaceContentEntityObject) {
            spaceKey = ((SpaceContentEntityObject)contentObject).getSpaceKey();
        } else if (contentObject instanceof Draft) {
            spaceKey = ((Draft)contentObject).getDraftSpaceKey();
        }
        return spaceKey;
    }
}

