/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.components;

import com.benryan.conversion.SlideConversionDataSerializer;
import com.benryan.conversion.SlidePageConversionData;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class ConvertedPageResult<T>
extends ForwardingFuture<SlidePageConversionData>
implements ListenableFuture<SlidePageConversionData> {
    private final ListenableFuture<T> wrappedBatchFuture;
    private final int slideNum;
    private final ExecutionList listeners = new ExecutionList();

    public static final ConvertedPageResult<?> createPdfConversionResult(ListenableFuture<Collection<SlidePageConversionData>> wrappedFuture, int slideNum) {
        return new ConvertedPageResult<Collection<SlidePageConversionData>>(wrappedFuture, slideNum){

            @Override
            protected SlidePageConversionData findPage(Collection<SlidePageConversionData> pages) throws ExecutionException {
                if (pages == null || pages.isEmpty()) {
                    return null;
                }
                for (SlidePageConversionData page : pages) {
                    if (page.getSlideNum() != this.getSlideNum()) continue;
                    return page;
                }
                return null;
            }
        };
    }

    public static final ConvertedPageResult<SlideConversionDataSerializer> createPptConversionResult(ListenableFuture<SlideConversionDataSerializer> wrappedFuture, int slideNum) {
        return new ConvertedPageResult<SlideConversionDataSerializer>(wrappedFuture, slideNum){

            @Override
            SlidePageConversionData findPage(SlideConversionDataSerializer delegateResult) throws ExecutionException {
                if (delegateResult == null) {
                    return null;
                }
                return delegateResult.getPage(this.getSlideNum());
            }
        };
    }

    public static ConvertedPageResult<SlideConversionDataSerializer> copyPptConversionResult(ConvertedPageResult<SlideConversionDataSerializer> toCopy, int newSlideNum) {
        return ConvertedPageResult.createPptConversionResult((ListenableFuture<SlideConversionDataSerializer>)toCopy.delegate(), newSlideNum);
    }

    private ConvertedPageResult(ListenableFuture<T> wrappedFuture, int slideNum) {
        this.wrappedBatchFuture = wrappedFuture;
        this.slideNum = slideNum;
        this.wrappedBatchFuture.addListener(new Runnable(){

            @Override
            public void run() {
                ConvertedPageResult.this.done();
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
    }

    protected final ListenableFuture delegate() {
        return this.wrappedBatchFuture;
    }

    abstract SlidePageConversionData findPage(T var1) throws ExecutionException;

    public final SlidePageConversionData get() throws InterruptedException, ExecutionException {
        return this.findPage(this.wrappedBatchFuture.get());
    }

    public final SlidePageConversionData get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.findPage(this.wrappedBatchFuture.get(timeout, unit));
    }

    protected final void done() {
        this.listeners.execute();
    }

    public final void addListener(Runnable listener, Executor exec) {
        this.listeners.add(listener, exec != null ? exec : MoreExecutors.sameThreadExecutor());
    }

    public final int getSlideNum() {
        return this.slideNum;
    }
}

