/*
 * Decompiled with CFR 0.152.
 */
package com.benryan.components;

import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.benryan.components.OcSettingsManager;
import com.benryan.conversion.ConversionCache;
import com.benryan.conversion.FileBackedCache;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

class AbstractConversionCacheManager<K, V> {
    private static final String OC_KEY = "com.atlassian.confluence.extra.officeconnector";
    protected static final Logger log = LoggerFactory.getLogger(AbstractConversionCacheManager.class);
    protected PageManager pageManager;
    protected AttachmentManager fileManager;
    private ConversionCache conversionCache;
    protected Date lastUpgrade = new Date();
    protected OcSettingsManager ocSettingsManager;

    AbstractConversionCacheManager() {
    }

    protected String buildBaseKey(String attachmentId) {
        return attachmentId;
    }

    @Autowired
    public void setPageManager(PageManager manager) {
        this.pageManager = manager;
    }

    @Autowired
    public void setAttachmentManager(AttachmentManager manager) {
        this.fileManager = manager;
    }

    public void initCache() {
        switch (this.ocSettingsManager.getCacheType()) {
            case 0: 
            case 1: 
            case 2: {
                String path = this.ocSettingsManager.getCacheDir();
                try {
                    this.conversionCache = new FileBackedCache(path);
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                break;
            }
        }
    }

    @Autowired
    public void setOcSettingsManager(OcSettingsManager manager) {
        this.ocSettingsManager = manager;
        this.initCache();
    }

    public void setPluginAccessor(PluginAccessor accessor) {
        Plugin plugin = accessor.getPlugin(OC_KEY);
        this.lastUpgrade = plugin.getDateLoaded();
    }

    public void putToCache(K key, V value) {
        this.conversionCache.put(key, value);
    }

    public V getFromCache(K key) {
        return (V)this.conversionCache.get(key);
    }
}

