/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.office.canary;

import com.atlassian.confluence.extra.office.canary.CanaryCage;
import com.atlassian.confluence.extra.office.canary.CanaryEnvironment;
import com.atlassian.fugue.Maybe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanaryCageFactory {
    private static final Logger log = LoggerFactory.getLogger(CanaryCageFactory.class);

    @Nonnull
    public static CanaryCage newCanaryCage(Path privateWorkingDirectory, String canaryJarResourceLocation, String mainClassFullname) throws Exception {
        log.info("Initialising cage for {}", (Object)canaryJarResourceLocation);
        CanaryEnvironment environment = CanaryEnvironment.currentEnv();
        Maybe<Path> javaExePath = environment.findJavaExePath();
        if (javaExePath.isEmpty()) {
            throw new UnsupportedOperationException("Failed to determine java executable path. Canary has nothing to perch on.");
        }
        Path canaryJarFile = CanaryCageFactory.extractCanaryJarToFile(privateWorkingDirectory, canaryJarResourceLocation);
        CanaryCage canaryCage = new CanaryCage(environment, canaryJarFile, mainClassFullname);
        log.info("Successfully initialised canary cage for {}", (Object)canaryJarResourceLocation);
        return canaryCage;
    }

    /*
     * Loose catch block
     */
    private static Path extractCanaryJarToFile(Path privateWorkingDirectory, String canaryJarResourceLocation) throws IOException {
        ClassLoader classLoader = CanaryCage.class.getClassLoader();
        InputStream canaryJarInputStream = classLoader.getResourceAsStream(canaryJarResourceLocation);
        if (canaryJarInputStream == null) {
            throw new IllegalStateException("Could not locate canary jar resource in classpath at " + canaryJarResourceLocation);
        }
        Path canaryJarFile = Files.createDirectories(privateWorkingDirectory, new FileAttribute[0]).resolve(canaryJarResourceLocation);
        log.info("Extracting canary JAR from from classpath at {} to disk file at {}", (Object)canaryJarResourceLocation, (Object)canaryJarFile.toAbsolutePath());
        try {
            try (OutputStream outputStream = Files.newOutputStream(canaryJarFile, new OpenOption[0]);){
                IOUtils.copy((InputStream)canaryJarInputStream, (OutputStream)outputStream);
                Path path = canaryJarFile;
                return path;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            canaryJarInputStream.close();
        }
    }
}

