/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.imageeffects.client;

import com.atlassian.fugue.Either;
import com.atlassian.imageeffects.client.Failure;
import com.atlassian.imageeffects.client.InputStreamConsumer;
import com.atlassian.imageeffects.client.Success;
import java.io.IOException;
import java.util.Objects;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TransformResponseHandler<R>
implements ResponseHandler<Either<Failure, Success<R>>> {
    private static final Logger log = LoggerFactory.getLogger(TransformResponseHandler.class);
    private static final int REQUEST_ENTITY_TOO_LARGE = 413;
    private static final int TOO_MANY_REQUESTS = 429;
    private final InputStreamConsumer<R> consumer;

    TransformResponseHandler(InputStreamConsumer<R> consumer) {
        this.consumer = Objects.requireNonNull(consumer);
    }

    public Either<Failure, Success<R>> handleResponse(HttpResponse response) throws IOException {
        log.debug("Got back {}", (Object)response.getStatusLine().getStatusCode());
        if (response.getStatusLine().getStatusCode() == 200) {
            try {
                R result = this.consumer.withInputStream(response.getEntity().getContent());
                return Either.right(new Success<R>(result));
            }
            catch (RuntimeException re) {
                return Either.left((Object)new Failure(Failure.Reason.CONSUMER_FAILURE, re));
            }
        }
        return this.mapFailure(response);
    }

    private Either<Failure, Success<R>> mapFailure(HttpResponse response) {
        Failure.Reason reason;
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 400: {
                reason = Failure.Reason.BAD_IMAGE;
                break;
            }
            case 413: {
                reason = Failure.Reason.IMAGE_TOO_LARGE;
                break;
            }
            case 429: {
                reason = Failure.Reason.TOO_MANY_REQUESTS;
                break;
            }
            case 503: {
                reason = Failure.Reason.TRANSFORM_TIMEOUT;
                break;
            }
            case 500: {
                reason = Failure.Reason.TRANSFORM_FAILURE;
                break;
            }
            default: {
                log.warn("Received unknown statusCode {}", (Object)statusCode);
                reason = Failure.Reason.UNKNOWN_RESPONSE;
            }
        }
        return Either.left((Object)new Failure(reason));
    }
}

