/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.imageeffects.client;

import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;

public class ConnectionDetails {
    private final URI serviceUri;
    private final int connectTimeout;
    private final int socketTimeout;
    private final int connectionTimeToLive;
    private final boolean trustSelfSignedCerts;
    private final int maxConnections;

    ConnectionDetails(URI serviceUri, int connectTimeout, int socketTimeout, int connectionTimeToLive, boolean trustSelfSignedCerts, int maxConnections) {
        this.serviceUri = Objects.requireNonNull(serviceUri, "Must set the serviceUri");
        this.connectTimeout = ConnectionDetails.checkPositive(connectTimeout, "connectTimeout");
        this.socketTimeout = ConnectionDetails.checkPositive(socketTimeout, "socketTimeout");
        this.connectionTimeToLive = ConnectionDetails.checkPositive(connectionTimeToLive, "connectionTimeToLive");
        this.trustSelfSignedCerts = trustSelfSignedCerts;
        this.maxConnections = ConnectionDetails.checkPositive(maxConnections, "maxConnections");
    }

    @Nonnull
    public URI getServiceUri() {
        return this.serviceUri;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getConnectionTimeToLive() {
        return this.connectionTimeToLive;
    }

    public boolean isTrustSelfSignedCerts() {
        return this.trustSelfSignedCerts;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    private static int checkPositive(int value, String parameter) {
        if (value <= 0) {
            throw new IllegalArgumentException("Parameter " + parameter + " must be positive, supplied " + value);
        }
        return value;
    }

    public String toString() {
        return "ConnectionDetails{serviceUri=" + this.serviceUri + ", connectTimeout=" + this.connectTimeout + ", socketTimeout=" + this.socketTimeout + ", connectionTimeToLive=" + this.connectionTimeToLive + ", trustSelfSignedCerts=" + this.trustSelfSignedCerts + ", maxConnections=" + this.maxConnections + '}';
    }
}

