/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.image.effects;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="cacheCleanup")
public class CacheCleanup
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(CacheCleanup.class);
    private final BootstrapManager bootstrapManager;

    public CacheCleanup(@ComponentImport BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            String cachePath = this.bootstrapManager.getApplicationHome() + File.separator + "imgEffects";
            this.cullOldFiles(cachePath, 500);
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            return JobRunnerResponse.failed((Throwable)e);
        }
    }

    private void cullOldFiles(String path, int maxSize) {
        File[] children;
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory() && (children = dir.listFiles()) != null && children.length > maxSize) {
            Arrays.sort(children, Comparator.comparingLong(File::lastModified));
            int endIndex = children.length - maxSize;
            for (int x = 0; x < endIndex && endIndex < children.length; ++x) {
                File oldestFile = children[x];
                if (oldestFile.getName().startsWith("preview")) {
                    ++endIndex;
                    continue;
                }
                if (oldestFile.delete()) continue;
                log.warn("Unable to delete cached conversion " + oldestFile.getAbsolutePath());
            }
        }
    }
}

