/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.image.effects;

import com.atlassian.confluence.image.effects.ImageEffectsConfig;
import com.atlassian.confluence.image.effects.TransformContext;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.imageeffects.client.ImageEffectsClient;
import com.atlassian.util.concurrent.Supplier;
import java.io.InputStream;
import java.util.Optional;

class TransformContextBuilder {
    private String imageLabel;
    private Long lastModified;
    private Supplier<InputStream> imageSupplier;
    private Long imageDataSize;
    private String cacheEntryName;
    private Boolean forbiddenAccess;
    private ImageEffectsConfig config;
    private Optional<ImageEffectsClient> client;
    private EventPublisher eventPublisher;
    private boolean rotationOnly = false;
    private boolean rotationAndThumbnailOnly = false;
    private Optional<Long> attachmentId = Optional.empty();

    TransformContextBuilder() {
    }

    public TransformContextBuilder imageLabel(String imageLabel) {
        this.imageLabel = imageLabel;
        return this;
    }

    public TransformContextBuilder lastModified(long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public TransformContextBuilder imageSupplier(Supplier<InputStream> imageSupplier) {
        this.imageSupplier = imageSupplier;
        return this;
    }

    public TransformContextBuilder cacheEntryName(String cacheEntryName) {
        this.cacheEntryName = cacheEntryName;
        return this;
    }

    public TransformContextBuilder forbiddenAccess(boolean forbiddenAccess) {
        this.forbiddenAccess = forbiddenAccess;
        return this;
    }

    public TransformContextBuilder config(ImageEffectsConfig config) {
        this.config = config;
        return this;
    }

    public TransformContextBuilder client(Optional<ImageEffectsClient> client) {
        this.client = client;
        return this;
    }

    public TransformContextBuilder imageDataSize(long imageDataSize) {
        this.imageDataSize = imageDataSize;
        return this;
    }

    public TransformContextBuilder eventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        return this;
    }

    public TransformContextBuilder rotationOnly(boolean rotationOnly) {
        this.rotationOnly = rotationOnly;
        return this;
    }

    public TransformContextBuilder rotationAndThumbnailOnly(boolean rotationAndThumbnailOnly) {
        this.rotationAndThumbnailOnly = rotationAndThumbnailOnly;
        return this;
    }

    public TransformContextBuilder attachmentId(long attachmentId) {
        this.attachmentId = Optional.of(attachmentId);
        return this;
    }

    public TransformContext build() {
        return new TransformContext(this.imageLabel, this.lastModified, this.imageSupplier, this.imageDataSize, this.cacheEntryName, this.forbiddenAccess, this.config, this.client, this.eventPublisher, this.rotationOnly, this.rotationAndThumbnailOnly, this.attachmentId);
    }
}

