/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.image.effects;

import com.atlassian.confluence.image.effects.ImageCacheCleanupJobDetail;
import com.atlassian.confluence.setup.BootstrapManager;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheCleanup
implements Job {
    private static final Logger log = LoggerFactory.getLogger(CacheCleanup.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        ImageCacheCleanupJobDetail jobDetail = (ImageCacheCleanupJobDetail)context.getJobDetail();
        BootstrapManager bootstrapManager = jobDetail.getBootstrapManager();
        String cachePath = bootstrapManager.getApplicationHome() + File.separator + "imgEffects";
        this.cullOldFiles(cachePath, 500);
    }

    private void cullOldFiles(String path, int maxSize) {
        File[] children;
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory() && (children = dir.listFiles()) != null && children.length > maxSize) {
            Arrays.sort(children, Comparator.comparingLong(File::lastModified));
            int endIndex = children.length - maxSize;
            for (int x = 0; x < endIndex && endIndex < children.length; ++x) {
                File oldestFile = children[x];
                if (oldestFile.getName().startsWith("preview")) {
                    ++endIndex;
                    continue;
                }
                if (oldestFile.delete()) continue;
                log.warn("Unable to delete cached conversion " + oldestFile.getAbsolutePath());
            }
        }
    }
}

