/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.webdav.listener;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.page.PageRestoreEvent;
import com.atlassian.confluence.extra.webdav.ConfluenceDavSession;
import com.atlassian.confluence.extra.webdav.ConfluenceDavSessionStore;
import com.atlassian.confluence.extra.webdav.ConfluenceDavSessionTask;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;

public class PageRestoreListener
implements EventListener {
    private static final Class[] HANDLED_EVENTS = new Class[]{PageRestoreEvent.class};
    private ConfluenceDavSessionStore confluenceDavSessionStore;

    public void setConfluenceDavSessionStore(ConfluenceDavSessionStore confluenceDavSessionStore) {
        this.confluenceDavSessionStore = confluenceDavSessionStore;
    }

    public void handleEvent(Event event) {
        this.confluenceDavSessionStore.executeTaskOnSessions(new ContentEntityAttributesResetDavSessionTask(((PageRestoreEvent)event).getContent()));
    }

    public Class[] getHandledEventClasses() {
        return HANDLED_EVENTS;
    }

    private static class ContentEntityAttributesResetDavSessionTask
    implements ConfluenceDavSessionTask {
        private final ContentEntityObject ceo;

        private ContentEntityAttributesResetDavSessionTask(ContentEntityObject ceo) {
            this.ceo = ceo;
        }

        @Override
        public void execute(ConfluenceDavSession confluenceDavSession) {
            confluenceDavSession.getResourceStates().resetContentAttributes(this.ceo);
        }
    }
}

