/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.ext.usage.event;

import com.atlassian.confluence.ext.usage.event.ThrottlingRejectedExecutionHandler;
import com.atlassian.confluence.ext.usage.event.UsageEventWrapperTask;
import com.atlassian.confluence.ext.usage.index.UsageIndexManager;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UsageTaskQueue {
    private static final int QUEUE_CAPACITY = 1000;
    private static final Logger log = Logger.getLogger(UsageTaskQueue.class);
    private final UsageIndexManager usageIndexManager;
    private final ThreadPoolExecutor executor;

    @Autowired
    public UsageTaskQueue(UsageIndexManager usageIndexManager) {
        this.usageIndexManager = usageIndexManager;
        this.executor = this.createExecutor();
    }

    private ThreadPoolExecutor createExecutor() {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(1000);
        ThrottlingRejectedExecutionHandler handler = new ThrottlingRejectedExecutionHandler((r, executor) -> log.error((Object)"Discarding usage event(s) because task queue is full. Usage statistics may not be accurate."));
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, queue, handler);
    }

    public Future<?> addTask(UsageEventWrapperTask task) {
        return this.executor.submit(() -> {
            if (log.isDebugEnabled()) {
                log.debug((Object)("UsageEventListener.run: " + task));
            }
            try {
                this.usageIndexManager.index(task);
            }
            catch (Throwable t) {
                log.error((Object)("Error indexing task: " + task + ": " + t), t);
            }
        });
    }

    public boolean waitUntilQueueProcessed(long timeoutMillis) {
        Future<Boolean> future = this.executor.submit(() -> true);
        try {
            return future.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    Queue<Runnable> getQueue() {
        return new LinkedList<Runnable>(this.executor.getQueue());
    }
}

