package com.atlassian.confluence.ext.usage.query;

import com.atlassian.confluence.ext.usage.UsagePeriod;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

import java.util.Date;

/**
 * Utility methods to do with data manipulation.
 */
public class UsageDataUtils {

    public static RegularTimePeriod getTimePeriod(String periodName, Date date) {
        return RegularTimePeriod.createInstance(getTimePeriodClass(periodName), date, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public static Class getTimePeriodClass(final String periodName) {
        return UsagePeriod.resolve(periodName).getType();
    }

    /**
     * Creates a TimeSeriesCollection which represents the cumulative values of a given TimeSeriesCollection.
     *
     * @param collection collection
     * @return TimeSeriesCollection
     */
    public static TimeSeriesCollection makeCumulative(TimeSeriesCollection collection) {
        TimeSeriesCollection result = new TimeSeriesCollection();

        for (int i = 0; i < collection.getSeriesCount(); i++) {
            TimeSeries oldSeries = collection.getSeries(i);
            TimeSeries cumulativeSeries = new TimeSeries(oldSeries.getKey(), oldSeries.getTimePeriodClass());
            int cumulativeValue = 0;
            for (int j = 0; j < oldSeries.getItemCount(); j++) {
                cumulativeValue += oldSeries.getValue(j).intValue();
                cumulativeSeries.add(oldSeries.getTimePeriod(j), Integer.valueOf(cumulativeValue));
            }
            result.addSeries(cumulativeSeries);
        }

        return result;
    }

    public static void normaliseDateRange(TimeSeriesCollection collection, RegularTimePeriod[] range) {
        if (collection.getSeriesCount() == 0)
            return;

        // find earliest date, then move it forwards until we hit now
        RegularTimePeriod earliest = range[0];
        RegularTimePeriod latest = range[1];

        RegularTimePeriod cursor = earliest;

        for (int i = 0; i < collection.getSeriesCount(); i++) {
            TimeSeries series = collection.getSeries(i);

            while (cursor.compareTo(latest) != 1) {
                if (series.getValue(cursor) == null)
                    series.add(cursor, Integer.valueOf(0));

                cursor = cursor.next();
            }

            cursor = earliest;
        }
    }
}
