/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.sandbox;

import com.atlassian.confluence.util.sandbox.SandboxSerializer;
import com.atlassian.confluence.util.sandbox.SandboxSerializers;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SandboxPdfConversionResponse {
    private final boolean wasUnableToReadInputDocument;
    private final File resultingPdf;
    private final int pdfPagesNum;

    public static SandboxPdfConversionResponse ok(File resultingPdf, int pdfPagesNum) {
        return new SandboxPdfConversionResponse(false, resultingPdf, pdfPagesNum);
    }

    public static SandboxPdfConversionResponse couldNotReadInputDocument() {
        return new SandboxPdfConversionResponse(true, null, -1);
    }

    public SandboxPdfConversionResponse(boolean wasUnableToReadInputDocument, File resultingPdf, int pdfSize) {
        this.wasUnableToReadInputDocument = wasUnableToReadInputDocument;
        this.resultingPdf = resultingPdf;
        this.pdfPagesNum = pdfSize;
    }

    public boolean wasUnableToReadInputDocument() {
        return this.wasUnableToReadInputDocument;
    }

    public File getResultingPdf() {
        return this.resultingPdf;
    }

    public int getPdfPagesNum() {
        return this.pdfPagesNum;
    }

    static Serializer serializer() {
        return Serializer.instance;
    }

    static final class Serializer
    implements SandboxSerializer<SandboxPdfConversionResponse> {
        static final Serializer instance = new Serializer();

        private Serializer() {
        }

        public byte[] serialize(SandboxPdfConversionResponse conversionResponse) {
            ArrayList<byte[]> fields = new ArrayList<byte[]>();
            fields.add(SandboxSerializers.intSerializer().serialize((Object)(conversionResponse.wasUnableToReadInputDocument ? 1 : 0)));
            String filePathOrNull = Optional.ofNullable(conversionResponse.getResultingPdf()).map(File::getAbsolutePath).orElse(null);
            fields.add(SandboxSerializers.stringSerializer().serialize((Object)filePathOrNull));
            fields.add(SandboxSerializers.intSerializer().serialize((Object)conversionResponse.pdfPagesNum));
            return SandboxSerializers.compositeByteArraySerializer().serialize(fields);
        }

        public SandboxPdfConversionResponse deserialize(byte[] bytes) {
            List fields = (List)SandboxSerializers.compositeByteArraySerializer().deserialize(bytes);
            return new SandboxPdfConversionResponse((Integer)SandboxSerializers.intSerializer().deserialize((byte[])fields.get(0)) == 1, new File((String)SandboxSerializers.stringSerializer().deserialize((byte[])fields.get(1))), (Integer)SandboxSerializers.intSerializer().deserialize((byte[])fields.get(2)));
        }
    }
}

