/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.extra.flyingpdf.PdfExportProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.analytic.EnvironmentInfo;
import com.atlassian.confluence.extra.flyingpdf.analytic.ExportResults;
import com.atlassian.confluence.extra.flyingpdf.analytic.ExportScope;
import com.atlassian.confluence.extra.flyingpdf.analytic.ExportStatus;
import com.atlassian.confluence.extra.flyingpdf.analytic.FailureLocation;
import com.atlassian.confluence.extra.flyingpdf.analytic.PageExportMetrics;
import com.atlassian.confluence.extra.flyingpdf.analytic.PdfExportAnalyticEvent;
import com.atlassian.confluence.extra.flyingpdf.analytic.SandboxStatus;
import com.atlassian.confluence.extra.flyingpdf.analytic.SpaceExportMetrics;
import com.atlassian.confluence.extra.flyingpdf.html.DecorationPolicy;
import com.atlassian.confluence.extra.flyingpdf.impl.DelegatingPdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.impl.PdfExportEvent;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.io.File;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={PdfExporterService.class})
public class BigBrotherPdfExporterService
implements PdfExporterService {
    private final EventPublisher eventPublisher;
    private final ClusterManager clusterManager;
    private final DelegatingPdfExporterService delegate;

    public BigBrotherPdfExporterService(@ComponentImport EventPublisher eventPublisher, @ComponentImport ClusterManager clusterManager, DelegatingPdfExporterService delegate) {
        this.eventPublisher = eventPublisher;
        this.clusterManager = clusterManager;
        this.delegate = delegate;
    }

    @Override
    public File createPdfForSpace(User user, Space space, ContentTree contentTree, PdfExportProgressMonitor progress, String contextPath, SpaceExportMetrics spaceExportMetrics, DecorationPolicy decorations) throws ImportExportException {
        spaceExportMetrics.setConfluencePages(contentTree.size());
        this.fillEnvironmentData(space, spaceExportMetrics.getEnvironmentInfo());
        long startTime = System.currentTimeMillis();
        try {
            File result = this.delegate.createPdfForSpace(user, space, contentTree, progress, contextPath, spaceExportMetrics, decorations);
            spaceExportMetrics.getExportResults().setExportStatus(ExportStatus.OK);
            File file = result;
            return file;
        }
        catch (Exception e) {
            this.setGenericError(spaceExportMetrics.getExportResults());
            throw e;
        }
        finally {
            spaceExportMetrics.setTotalTime((int)(System.currentTimeMillis() - startTime));
            this.eventPublisher.publish((Object)new PdfExportEvent(space));
            this.eventPublisher.publish((Object)new PdfExportAnalyticEvent(spaceExportMetrics));
        }
    }

    @Override
    public File createPdfForPage(User user, AbstractPage page, String contextPath, PageExportMetrics pageExportMetrics) throws ImportExportException {
        pageExportMetrics.setPageId(page.getId());
        pageExportMetrics.setPageRevision(page.getConfluenceRevision().hashCode());
        this.fillEnvironmentData(page, pageExportMetrics.getEnvironmentInfo());
        try {
            File file = this.delegate.createPdfForPage(user, page, contextPath, pageExportMetrics);
            return file;
        }
        catch (Exception e) {
            pageExportMetrics.getExportResults().setFailureLocation(FailureLocation.PAGE);
            this.setGenericError(pageExportMetrics.getExportResults());
            throw e;
        }
        finally {
            this.eventPublisher.publish((Object)new PdfExportEvent(page));
            this.eventPublisher.publish((Object)new PdfExportAnalyticEvent(pageExportMetrics));
        }
    }

    private void setGenericError(ExportResults results) {
        if (results.getExportStatus() == null) {
            results.setExportStatus(ExportStatus.FAIL);
            results.setFailureLocation(FailureLocation.INTERNAL);
        }
    }

    private void fillEnvironmentData(Space space, EnvironmentInfo environmentInfo) {
        if (this.clusterManager.isClustered()) {
            environmentInfo.setDcNodeId(Optional.ofNullable(this.clusterManager.getThisNodeInformation()).map(ClusterNodeInformation::getAnonymizedNodeIdentifier).map(Object::hashCode).orElse(-1));
        }
        environmentInfo.setSpaceKey(space.getKey());
        environmentInfo.setSpaceName(space.getName());
        environmentInfo.setExportScope(ExportScope.SPACE);
        environmentInfo.setSandboxStatus(this.delegate.sandboxIsUsed() ? SandboxStatus.USED : SandboxStatus.NOT_USED);
    }

    private void fillEnvironmentData(AbstractPage page, EnvironmentInfo environmentInfo) {
        Space space = page.getSpace();
        environmentInfo.setPageName(page.getTitle());
        environmentInfo.setPageType(page.getType());
        environmentInfo.setSpaceName(space.getName());
        environmentInfo.setSpaceKey(space.getKey());
        environmentInfo.setExportScope(ExportScope.PAGE);
    }

    @Override
    public ContentTree getContentTree(User user, Space space) {
        return this.delegate.getContentTree(user, space);
    }

    @Override
    public boolean isPermitted(User user, AbstractPage page) {
        return this.delegate.isPermitted(user, page);
    }

    @Override
    public boolean isPermitted(User user, Space space) {
        return this.delegate.isPermitted(user, space);
    }

    @Override
    public boolean exportableContentExists(Space space) {
        return this.delegate.exportableContentExists(space);
    }

    @Override
    public PdfExportProgressMonitor createProgressMonitor(ProgressMeter progressMeter) {
        return this.delegate.createProgressMonitor(progressMeter);
    }
}

