package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.confluence.extra.flyingpdf.util.ErrorMessages;
import org.springframework.stereotype.Component;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/**
 * Put the hard limit on the number of parallel PDF exports
 */
@Component
public class PdfExportSemaphore {

    private static final Integer PERMITS_SIZE = Integer.getInteger("confluence.pdfexport.permits.size", Runtime.getRuntime().availableProcessors());
    private static final Integer TIMEOUT_SECONDS = Integer.getInteger("confluence.pdfexport.timeout.seconds", 30);
    private final Semaphore semaphore = new Semaphore(PERMITS_SIZE, true);

    private final ErrorMessages errorMessages;

    public PdfExportSemaphore(ErrorMessages errorMessages) {
        this.errorMessages = errorMessages;
    }

    public void run(Runnable runnable) {
        if (acquire()) {
            try {
                runnable.run();
            } finally {
                release();
            }
        } else {
            final String message = errorMessages.tooManyConcurrentExports();
            throw new RuntimeException(message);
        }
    }

    private boolean acquire() {
        try {
            return semaphore.tryAcquire(TIMEOUT_SECONDS, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            return false;
        }
    }

    private void release() {
        semaphore.release();
    }

}
