package com.atlassian.confluence.extra.flyingpdf.html;

import org.apache.velocity.context.Context;

import java.io.Writer;

/**
 * Generates the HTML for export.
 *
 * Wraps the function into a service to make it easier for testing.
 */
public interface ExportHtmlService {

    /**
     * Renders the HTML contents given the template.
     *
     * @param templateName - velocity template name
     * @param context - velocity context
     * @param writer - the writer where the html will be saved
     * @throws Exception when error occurs
     *
     * @since 3.5.6
     */
    void renderTemplateWithoutSwallowingErrors(String templateName, Context context, Writer writer) throws Exception;
}
