package com.atlassian.confluence.extra.flyingpdf.html;

import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.xhtmlrenderer.simple.extend.XhtmlNamespaceHandler;

public class ConfluenceNamespaceHandler extends XhtmlNamespaceHandler {

    private String baseUrl;

    public ConfluenceNamespaceHandler(String baseUrl) {
        super();
        this.baseUrl = baseUrl;
    }

    @Override
    public String getLinkUri(Element e) {
        String uri = super.getLinkUri(e);
        if (StringUtils.isNotBlank(uri) && uri.charAt(0) == '/') {
            uri = baseUrl + uri;
        }
        return uri;
    }

}
