package com.atlassian.confluence.extra.flyingpdf.util;

import com.atlassian.annotations.Internal;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;

/**
 * Uses a pre defined list of {@link com.atlassian.confluence.extra.flyingpdf.util.PdfPageProcessor}
 * to process pages of a PDF file sequentially.
 */
@Internal
public class PdfPostProcessor {

    private final String inputFile;
    private final String outputFile;
    private final List<PdfPageProcessor> pageProcessors;

    public PdfPostProcessor(String inputFile, String outputFile, List<PdfPageProcessor> pageProcessors) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.pageProcessors = pageProcessors;
    }

    public void run() throws IOException, DocumentException {
        final PdfReader reader = new PdfReader(inputFile);
        final PdfStamper stamper = new PdfStamper(reader, new FileOutputStream(outputFile));
        processPdf(reader, stamper);
        stamper.close();
        reader.close();
    }

    private void processPdf(final PdfReader reader, final PdfStamper stamper) {
        for (int page = 1; page <= reader.getNumberOfPages(); page++) {
            if (page > 1) {
                reader.releasePage(page - 1);
            }

            for (PdfPageProcessor processor : pageProcessors) {
                processor.processPage(reader, stamper, page);
            }
        }
    }
}
