package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;

public class GlobalConfigurePdfExportLayout
        extends AbstractConfigurePdfExportAction {

    private String header;
    private String footer;
    private String titlePage;


    public void setTitlePage(String titlePage) {
        this.titlePage = titlePage;
    }

    public String getTitlePage() {
        return pdfSettings.getTitlePage(getBandanaContext());
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return pdfSettings.getHeader(getBandanaContext());
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getFooter() {
        return pdfSettings.getFooter(getBandanaContext());
    }

    @PermittedMethods({HttpMethod.GET, HttpMethod.POST})
    @XsrfProtectionExcluded
    public String execute() {
        return SUCCESS;
    }

    public String doEdit() {
        pdfSettings.setTitlePage(getBandanaContext(), titlePage);
        pdfSettings.setHeader(getBandanaContext(), header);
        pdfSettings.setFooter(getBandanaContext(), footer);
        return SUCCESS;
    }

}
