/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.util;

import com.atlassian.config.util.BootstrapUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageFileCacheUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageFileCacheUtils.class);
    private static final String TEMP_EXPORT_FOLDER_PREFIX = "pdf-export";
    private static final ThreadLocal<String> threadLocal = new ThreadLocal();

    public static void initializeConfluenceTempExportDirectory() {
        File tempExportDirectory = ImageFileCacheUtils.createTempDirectoryInConfluenceTemp(TEMP_EXPORT_FOLDER_PREFIX);
        if (!tempExportDirectory.mkdir()) {
            log.error("Unable to create temp folder {}", (Object)tempExportDirectory);
        } else {
            log.debug("Temp directory {} for pdf export was created", (Object)tempExportDirectory.getAbsolutePath());
        }
        threadLocal.set(tempExportDirectory.getAbsolutePath());
    }

    public static void initializeSandboxTempExportDirectory() {
        File tempExportDirectory = ImageFileCacheUtils.createTempDirectoryInCurrentFolder(TEMP_EXPORT_FOLDER_PREFIX);
        if (!tempExportDirectory.mkdir()) {
            log.error("Unable to create temp folder {}", (Object)tempExportDirectory);
        } else {
            log.debug("Temp directory {} for pdf export was created", (Object)tempExportDirectory.getAbsolutePath());
        }
        threadLocal.set(tempExportDirectory.getAbsolutePath());
    }

    public static void removeTempDirectory() {
        try {
            FileUtils.deleteDirectory((File)new File(threadLocal.get()));
        }
        catch (IOException e) {
            log.warn("Cannot remove temporary directory: " + threadLocal.get());
        }
        finally {
            threadLocal.remove();
        }
    }

    public static File createTempFile(InputStream inputStream) throws IOException {
        File tempFile = ImageFileCacheUtils.createTempFile(threadLocal.get());
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
        return tempFile;
    }

    public static File createTempFile(byte[] bytes) throws IOException {
        File tempFile = ImageFileCacheUtils.createTempFile(threadLocal.get());
        FileUtils.writeByteArrayToFile((File)tempFile, (byte[])bytes);
        return tempFile;
    }

    private static File createTempDirectoryInConfluenceTemp(String prefix) {
        String uniqueRandomFileName = UUID.randomUUID().toString();
        return new File(BootstrapUtils.getBootstrapManager().getFilePathProperty("webwork.multipart.saveDir"), prefix + uniqueRandomFileName);
    }

    private static File createTempDirectoryInCurrentFolder(String prefix) {
        String uniqueRandomFileName = UUID.randomUUID().toString();
        Path currentRelativePath = Paths.get("", new String[0]);
        String currentFolder = currentRelativePath.toAbsolutePath().toString();
        return new File(currentFolder, prefix + uniqueRandomFileName);
    }

    private static File createTempFile(String directory) {
        String uniqueRandomFileName = UUID.randomUUID().toString();
        return new File(directory, uniqueRandomFileName);
    }
}

