/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.upgrade;

import com.atlassian.confluence.extra.flyingpdf.config.FontManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class UpgradePdfLanguageSupport
implements InitializingBean {
    private static final Logger LOGGER = Logger.getLogger(UpgradePdfLanguageSupport.class);
    private final FontManager pdfExportFontManager;
    private final BootstrapManager bootstrapManager;

    public UpgradePdfLanguageSupport(@ComponentImport BootstrapManager bootstrapManager, FontManager pdfExportFontManager) {
        this.pdfExportFontManager = pdfExportFontManager;
        this.bootstrapManager = bootstrapManager;
    }

    public void afterPropertiesSet() {
        if (this.pdfExportFontManager.isCustomFontInstalled()) {
            return;
        }
        File fontDir = new File(this.bootstrapManager.getApplicationHome() + File.separator + "fonts");
        if (!fontDir.exists()) {
            return;
        }
        File[] fontFiles = fontDir.listFiles();
        if (fontFiles == null || fontFiles.length == 0) {
            return;
        }
        if (fontFiles.length > 1) {
            LOGGER.warn((Object)"More than one file was found in the font directory - custom font will not be migrated for use with the PDF Export plugin.");
            return;
        }
        try {
            String tempDir = this.bootstrapManager.getFilePathProperty("webwork.multipart.saveDir") + File.separator + System.currentTimeMillis();
            File tempFontDir = new File(tempDir);
            if (!tempFontDir.mkdir()) {
                throw new IOException("Failed to create the temporary font storage directory " + tempFontDir);
            }
            File tempFontFile = new File(tempFontDir, fontFiles[0].getName());
            if (!fontFiles[0].renameTo(tempFontFile)) {
                throw new IOException("Could not move the currently installed font " + fontFiles[0].getAbsolutePath() + " to a temporary location of " + tempDir);
            }
            this.pdfExportFontManager.installFont((Resource)new FileSystemResource(tempFontFile));
            LOGGER.info((Object)("Successfully made the font " + fontFiles[0] + " available for use in the PDF export plugin."));
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Failed to make the font " + fontFiles[0] + " available for use in the PDF export plugin. Please install the font manually."), (Throwable)ex);
        }
    }
}

