/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.impl;

import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.analytic.PageExportMetrics;
import com.atlassian.confluence.extra.flyingpdf.impl.DiagnosticPdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.impl.PdfExportSemaphore;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportPageAsPdfAction
extends AbstractPageAwareAction {
    private static final Logger log = LoggerFactory.getLogger(ExportPageAsPdfAction.class);
    private GateKeeper gateKeeper;
    private String downloadPath;
    private PdfExporterService pdfExporterService;
    private PdfExportSemaphore pdfExportSemaphore;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        this.pdfExportSemaphore.run(this::doExecute);
        return "download";
    }

    private void doExecute() {
        try {
            String contextPath = this.getServletRequest().getContextPath();
            File exportedDocument = this.pdfExporterService.createPdfForPage(this.getRemoteUser(), this.getPage(), contextPath, new PageExportMetrics());
            String rawPath = this.prepareDownloadPath(exportedDocument);
            this.downloadPath = this.addPdfContentTypeParam(this.replaceBackslashes(this.encodePath(rawPath)));
            String gatekeeperPath = this.replaceBackslashes(rawPath);
            this.gateKeeper.addKey(gatekeeperPath, this.getRemoteUser());
        }
        catch (ImportExportException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected HttpServletRequest getServletRequest() {
        return ServletContextThreadLocal.getRequest();
    }

    public boolean isPermitted() {
        return this.pdfExporterService.isPermitted(this.getRemoteUser(), this.getPage());
    }

    private String prepareDownloadPath(File file) throws IOException {
        String homeDir = this.getBootstrapManager().getLocalHome().getCanonicalPath();
        String canonicalPath = file.getCanonicalPath();
        int homeDirIndex = canonicalPath.indexOf(homeDir);
        String urlPath = null;
        if (homeDirIndex != -1) {
            urlPath = canonicalPath.substring(homeDirIndex + homeDir.length() + 1);
        } else {
            for (File root : File.listRoots()) {
                String rootPath = root.getCanonicalPath();
                int rootIndex = canonicalPath.indexOf(rootPath);
                if (rootIndex == -1) continue;
                urlPath = canonicalPath.substring(rootIndex + rootPath.length());
                break;
            }
            if (urlPath == null) {
                log.warn("Path to the download [ {} ] has not been stripped of any parent directories, and may be invalid", (Object)file);
                urlPath = file.getPath();
            }
        }
        return "/download/" + urlPath;
    }

    private String addPdfContentTypeParam(String url) {
        return url + "?contentType=application/pdf";
    }

    private String replaceBackslashes(String relativeFilePath) {
        return relativeFilePath.replaceAll("\\\\", "/");
    }

    private String encodePath(String urlPath) throws UnsupportedEncodingException {
        int lastSlash = urlPath.lastIndexOf(File.separator);
        String prefix = "";
        if (lastSlash != -1) {
            prefix = urlPath.substring(0, lastSlash);
        }
        String suffix = urlPath.substring(lastSlash + 1, urlPath.length());
        String encodedSuffix = URLEncoder.encode(suffix, "UTF-8");
        urlPath = lastSlash != -1 ? prefix + '/' + encodedSuffix : encodedSuffix;
        return urlPath;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setDiagnosticsPdfExporterService(DiagnosticPdfExporterService diagnosticsPdfExporterService) {
        this.pdfExporterService = diagnosticsPdfExporterService;
    }

    public void setPdfExportSemaphore(PdfExportSemaphore pdfExportSemaphore) {
        this.pdfExportSemaphore = pdfExportSemaphore;
    }
}

