package com.atlassian.confluence.extra.flyingpdf;

/**
 * An interface implemented by class that want to be informed about the progress of the Pdf export task.
 */
public interface PdfExportProgressMonitor {
    /**
     * Will be called when the export process starts.
     */
    void started();

    /**
     * Called when the calculation of the Content Tree to be exported is started.
     */
    void beginCalculationOfContentTree();

    /**
     * Called when the number of pdf pages are calculated
     *
     * @param numberOfPages the number of pages that will be exported
     */
    void completedCalculationOfPdfPages(int numberOfPages);

    /**
     * Called when the Content Tree to be exported has been fully calculated.
     *
     * @param numberOfPages the number of pages that will be exported
     */
    void completedCalculationOfContentTree(int numberOfPages);

    /**
     * Will be called once for each page that is converted to HTML.
     *
     * @param pageId    the id of the page converted
     * @param pageTitle the title of the page converted
     */
    void completedExportedHtmlConversionForPage(String pageId, String pageTitle);

    /**
     * Called when the HTML to PDF conversion part of the process begins.
     */
    void beginHtmlToPdfConversion();

    /**
     * Called for each page that is being converted to PDF.
     */
    void performingHtmlToPdfConversionForPage(String pageTitle);

    /**
     * Will be called when the export completes with the path to download the exported file.
     */
    void completed(String downloadPath);

    /**
     * Will be called if the export fails during the export. The completed call will not be made in this case.
     *
     * @param exceptionMessage the message from the Exception that caused the error.
     */
    void errored(String exceptionMessage);
}
