/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf.config;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.extra.flyingpdf.config.PdfExportSettingsManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.actions.SpaceAware;

public class ConfigurePdfExportLayoutAction
extends ConfluenceActionSupport
implements SpaceAware {
    private PdfExportSettingsManager pdfSettings;
    private PermissionManager permissionManager;
    private Space space;
    private String header;
    private String footer;
    private String titlePage;

    public void setTitlePage(String titlePage) {
        this.titlePage = titlePage;
    }

    public String getTitlePage() {
        return this.pdfSettings.getTitlePage(this.space);
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.pdfSettings.getHeader(this.space);
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getFooter() {
        return this.pdfSettings.getFooter(this.space);
    }

    public String execute() {
        return "success";
    }

    public String doEdit() {
        this.pdfSettings.setTitlePage(this.space, this.titlePage);
        this.pdfSettings.setHeader(this.space, this.header);
        this.pdfSettings.setFooter(this.space, this.footer);
        return "success";
    }

    public void setPdfExportSettingsManager(PdfExportSettingsManager pdfSettings) {
        this.pdfSettings = pdfSettings;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public String getKey() {
        return this.space.getKey();
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getRemoteUser(), Permission.ADMINISTER, (Object)this.getSpace());
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public Space getSpace() {
        return this.space;
    }
}

