/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.flyingpdf;

import com.atlassian.confluence.core.service.NotAuthorizedException;
import com.atlassian.confluence.extra.flyingpdf.NoOpProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.PdfExportProgressMonitor;
import com.atlassian.confluence.extra.flyingpdf.PdfExporterService;
import com.atlassian.confluence.extra.flyingpdf.XmlToPdfConverter;
import com.atlassian.confluence.extra.flyingpdf.html.XhtmlBuilder;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.pages.ContentNode;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import java.io.File;
import org.w3c.dom.Document;

public class FlyingSaucerPdfExporterService
implements PdfExporterService {
    private ImportExportManager importExportManager;
    private XhtmlBuilder intermediateHtmlBuilder;
    private XmlToPdfConverter flyingPdfDocumentConverter;
    private PermissionManager permissionManager;

    public File createPdfForSpace(User user, Space space, ContentTree contentTree, String contextPath) throws ImportExportException {
        return this.createPdfForSpace(user, space, contentTree, this.newNoOpProgressMonitor(), contextPath);
    }

    protected NoOpProgressMonitor newNoOpProgressMonitor() {
        return new NoOpProgressMonitor();
    }

    public File createPdfForSpace(User user, Space space, ContentTree contentTree, PdfExportProgressMonitor progress, String contextPath) throws ImportExportException {
        this.checkAuthorization(user, space);
        progress.beginCalculationOfContentTree();
        progress.completedCalculationOfContentTree(contentTree.size());
        Document xhtml = this.intermediateHtmlBuilder.buildHtml(contentTree, space, true, progress);
        contentTree = null;
        String spaceKey = this.getSpaceKeyForExportFileName(space.getKey());
        progress.beginHtmlToPdfConversion();
        return this.flyingPdfDocumentConverter.convertXhtmlToPdf(spaceKey, xhtml, progress, contextPath);
    }

    public File createPdfForPage(User user, Page page, String contextPath) throws ImportExportException {
        this.checkAuthorization(user, page);
        ContentTree tree = this.newContentTree();
        tree.addRootNode(new ContentNode(page));
        Document xhtml = this.intermediateHtmlBuilder.buildHtml(tree, page.getSpace(), false);
        String spaceKey = this.getSpaceKeyForExportFileName(page.getSpaceKey());
        String filename = spaceKey + "-" + page.getId();
        return this.flyingPdfDocumentConverter.convertXhtmlToPdf(filename, xhtml, contextPath);
    }

    protected ContentTree newContentTree() {
        return new ContentTree();
    }

    public ContentTree getContentTree(User user, Space space) {
        return this.importExportManager.getContentTree(user, space);
    }

    public boolean isPermitted(User user, Page page) {
        if (this.isSuperUser(user)) {
            return true;
        }
        return this.permissionManager.hasPermission(user, Permission.EXPORT, (Object)page);
    }

    public boolean isPermitted(User user, Space space) {
        if (this.isSuperUser(user)) {
            return true;
        }
        return this.permissionManager.hasPermission(user, Permission.EXPORT, (Object)space);
    }

    protected boolean isSuperUser(User user) {
        return GeneralUtil.isSuperUser((User)user);
    }

    private void checkAuthorization(User user, Object target) {
        boolean permitted = false;
        if (target instanceof Space) {
            permitted = this.isPermitted(user, (Space)target);
        } else if (target instanceof Page) {
            permitted = this.isPermitted(user, (Page)target);
        }
        if (!permitted) {
            String username = user == null ? "anonymous" : user.getName();
            throw new NotAuthorizedException("The user " + username + " is not permitted to perform this export");
        }
    }

    private String getSpaceKeyForExportFileName(String spaceKey) {
        if (spaceKey.startsWith("~")) {
            spaceKey = spaceKey.substring(1);
        }
        return spaceKey;
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
    }

    public void setIntermediateHtmlBuilder(XhtmlBuilder intermediateHtmlBuilder) {
        this.intermediateHtmlBuilder = intermediateHtmlBuilder;
    }

    public void setFlyingPdfDocumentConverter(XmlToPdfConverter flyingPdfDocumentConverter) {
        this.flyingPdfDocumentConverter = flyingPdfDocumentConverter;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

