package com.atlassian.confluence.ext.code.descriptor.custom;

import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugin.osgi.external.SingleModuleDescriptorFactory;
import com.atlassian.plugin.spring.scanner.annotation.export.ModuleType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 *
 */
@ModuleType(ListableModuleDescriptorFactory.class)
@Component
public class CustomCodeSyntaxModuleDescriptorFactory extends
        SingleModuleDescriptorFactory<CustomCodeSyntaxModuleDescriptor> {
    /**
     * Constructs an instance using a specific host container
     *
     * @param hostContainer         The host container to use to create descriptor instances
     * @since 2.2.0
     */
    @Autowired
    public CustomCodeSyntaxModuleDescriptorFactory(final HostContainer hostContainer) {
        super(hostContainer, "code-syntax", CustomCodeSyntaxModuleDescriptor.class);
    }
}
